/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.rule.handler.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.rule.RuleEvaluationHandler;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.context.CardinalityContext;
import org.kie.workbench.common.stunner.core.rule.context.ElementCardinalityContext;
import org.kie.workbench.common.stunner.core.rule.context.GraphEvaluationState;
import org.kie.workbench.common.stunner.core.rule.context.impl.RuleEvaluationContextBuilder;
import org.kie.workbench.common.stunner.core.rule.handler.impl.CardinalityEvaluationHandler;
import org.kie.workbench.common.stunner.core.rule.handler.impl.GraphEvaluationHandlerUtils;
import org.kie.workbench.common.stunner.core.rule.impl.Occurrences;
import org.kie.workbench.common.stunner.core.rule.violations.DefaultRuleViolations;

@ApplicationScoped
public class ElementCardinalityEvaluationHandler
implements RuleEvaluationHandler<Occurrences, ElementCardinalityContext> {
    private final CardinalityEvaluationHandler cardinalityEvaluationHandler;
    private final GraphEvaluationHandlerUtils evalUtils;

    protected ElementCardinalityEvaluationHandler() {
        this(null, null);
    }

    @Inject
    public ElementCardinalityEvaluationHandler(DefinitionManager definitionManager, CardinalityEvaluationHandler cardinalityEvaluationHandler) {
        this.cardinalityEvaluationHandler = cardinalityEvaluationHandler;
        this.evalUtils = new GraphEvaluationHandlerUtils(definitionManager);
    }

    public Class<Occurrences> getRuleType() {
        return Occurrences.class;
    }

    public Class<ElementCardinalityContext> getContextType() {
        return ElementCardinalityContext.class;
    }

    public boolean accepts(Occurrences rule, ElementCardinalityContext context) {
        Collection candidates = context.getCandidates();
        return candidates.isEmpty() || candidates.stream().anyMatch(candidate -> this.accepts(rule, context, (Element<? extends View<?>>)candidate));
    }

    private boolean accepts(Occurrences rule, ElementCardinalityContext context, Element<? extends View<?>> candidate) {
        Set<String> candidateLabels = this.evalUtils.getLabels(candidate);
        return this.cardinalityEvaluationHandler.accepts(rule, RuleEvaluationContextBuilder.DomainContexts.cardinality(candidateLabels, -1, context.getOperation()));
    }

    public RuleViolations evaluate(Occurrences rule, ElementCardinalityContext context) {
        GraphEvaluationState state = context.getState();
        String role = rule.getRole();
        Set<String> roles = Collections.singleton(role);
        Map<String, Integer> graphLabelCount = this.countLabels(state, roles);
        Collection candidates = context.getCandidates();
        Collection filteredCandidates = candidates.stream().filter(candidate -> this.accepts(rule, context, (Element<? extends View<?>>)candidate)).collect(Collectors.toSet());
        int size = filteredCandidates.size();
        int count = graphLabelCount.isEmpty() ? 0 : graphLabelCount.get(role);
        Optional operation = context.getOperation();
        DefaultRuleViolations results = new DefaultRuleViolations();
        Function<String, RuleViolations> evaluator = uuid -> this.evaluate(rule, (String)uuid, roles, count, size, operation);
        if (size == 0) {
            results.addViolations(evaluator.apply(null));
        } else {
            filteredCandidates.forEach(candidate -> results.addViolations((RuleViolations)evaluator.apply(candidate.getUUID())));
        }
        return results;
    }

    private RuleViolations evaluate(Occurrences rule, String candidateUUID, Set<String> roles, int currentCount, int candidateCount, Optional<CardinalityContext.Operation> operation) {
        RuleViolations violations = this.cardinalityEvaluationHandler.evaluate(rule, RuleEvaluationContextBuilder.DomainContexts.cardinality(roles, currentCount, candidateCount, operation));
        return null != candidateUUID ? GraphEvaluationHandlerUtils.addViolationsSourceUUID(candidateUUID, violations) : violations;
    }

    Map<String, Integer> countLabels(GraphEvaluationState state, Set<String> roleFilter) {
        GraphEvaluationState.CardinalityState cardinalityState = state.getCardinalityState();
        Iterable nodes = cardinalityState.nodes();
        HashMap<String, Integer> labelsCount = new HashMap<String, Integer>();
        StreamSupport.stream(nodes.spliterator(), false).forEach(node -> GraphUtils.computeLabelsCount(node, labelsCount, roleFilter));
        return labelsCount;
    }
}

