/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.backend.workitem.deploy;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.WorkItemDefinitionResources;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.deploy.WorkItemDefinitionDeployService;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.service.WorkItemDefinitionRemoteRequest;
import org.kie.workbench.common.stunner.bpmn.project.backend.workitem.deploy.WorkItemDefinitionProjectInstaller;
import org.kie.workbench.common.stunner.bpmn.workitem.IconDefinition;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinition;
import org.kie.workbench.common.stunner.bpmn.workitem.service.WorkItemDefinitionService;
import org.kie.workbench.common.stunner.core.backend.service.BackendFileSystemManager;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class WorkItemDefinitionRemoteDeployService
implements WorkItemDefinitionDeployService {
    private static final Logger LOG = LoggerFactory.getLogger((String)WorkItemDefinitionRemoteDeployService.class.getName());
    public static final String PROPERTY_SERVICE_REPO = "org.jbpm.service.repository";
    public static final String PROPERTY_SERVICE_REPO_TASKNAMES = "org.jbpm.service.servicetasknames";
    private static final String DEPLOY_MESSAGE = "Deployment of the work item definitions from repository: ";
    private final BackendFileSystemManager backendFileSystemManager;
    private final WorkItemDefinitionService<WorkItemDefinitionRemoteRequest> remoteLookupService;
    private final WorkItemDefinitionResources resources;
    private final WorkItemDefinitionProjectInstaller projectInstaller;
    private final Function<WorkItemDefinition, BackendFileSystemManager.Asset> widAssetBuilder;
    private final Function<WorkItemDefinition, BackendFileSystemManager.Asset> iconAssetBuilder;

    protected WorkItemDefinitionRemoteDeployService() {
        this(null, null, null, null);
    }

    @Inject
    public WorkItemDefinitionRemoteDeployService(WorkItemDefinitionService<WorkItemDefinitionRemoteRequest> remoteLookupService, BackendFileSystemManager backendFileSystemManager, WorkItemDefinitionResources resources, WorkItemDefinitionProjectInstaller projectInstaller) {
        this(remoteLookupService, backendFileSystemManager, resources, projectInstaller, wid -> WorkItemDefinitionRemoteDeployService.createWIDAsset(wid).orElse(null), wid -> WorkItemDefinitionRemoteDeployService.createIconAsset(wid).orElse(null));
    }

    WorkItemDefinitionRemoteDeployService(WorkItemDefinitionService<WorkItemDefinitionRemoteRequest> remoteLookupService, BackendFileSystemManager backendFileSystemManager, WorkItemDefinitionResources resources, WorkItemDefinitionProjectInstaller projectInstaller, Function<WorkItemDefinition, BackendFileSystemManager.Asset> widAssetBuilder, Function<WorkItemDefinition, BackendFileSystemManager.Asset> iconAssetBuilder) {
        this.remoteLookupService = remoteLookupService;
        this.backendFileSystemManager = backendFileSystemManager;
        this.resources = resources;
        this.projectInstaller = projectInstaller;
        this.widAssetBuilder = widAssetBuilder;
        this.iconAssetBuilder = iconAssetBuilder;
    }

    public void deploy(Metadata metadata) {
        this.deploy(metadata, System.getProperty(PROPERTY_SERVICE_REPO), System.getProperty(PROPERTY_SERVICE_REPO_TASKNAMES));
    }

    void deploy(Metadata metadata, String url) {
        this.deploy(metadata, url, "");
    }

    void deploy(Metadata metadata, String url, String names) {
        Collection items;
        List assets;
        if (null != url && url.trim().length() > 0 && !(assets = (items = this.remoteLookupService.execute((Object)WorkItemDefinitionRemoteRequest.build((String)url, (String)names))).stream().flatMap(this::toAssets).collect(Collectors.toList())).isEmpty()) {
            this.backendFileSystemManager.deploy(this.resources.resolveResourcesPath(metadata), new BackendFileSystemManager.Assets(assets), DEPLOY_MESSAGE + url);
            this.projectInstaller.install(items, metadata);
        }
    }

    private Stream<BackendFileSystemManager.Asset> toAssets(WorkItemDefinition item) {
        return Stream.of(this.widAssetBuilder.apply(item), this.iconAssetBuilder.apply(item)).filter(Objects::nonNull);
    }

    private static Optional<BackendFileSystemManager.Asset> createWIDAsset(WorkItemDefinition item) {
        String uri = item.getUri();
        try {
            BackendFileSystemManager.Asset asset = new BackendFileSystemManager.AssetBuilder().setFileName(WorkItemDefinitionRemoteDeployService.parseFileName(uri)).stringFromURI(uri).build();
            return Optional.of(asset);
        }
        catch (IOException e) {
            LOG.error("Error reading work item definition asset from URL [" + item.getUri() + "]", (Throwable)e);
            return Optional.empty();
        }
    }

    private static Optional<BackendFileSystemManager.Asset> createIconAsset(WorkItemDefinition item) {
        IconDefinition icon = item.getIconDefinition();
        if (null != icon && null != icon.getUri()) {
            String path = WorkItemDefinitionRemoteDeployService.parsePath(item.getUri());
            String iconUri = icon.getUri();
            try {
                BackendFileSystemManager.Asset iconAsset = new BackendFileSystemManager.AssetBuilder().setFileName(WorkItemDefinitionRemoteDeployService.parseFileName(iconUri)).binaryFromURI(path + "/" + iconUri).build();
                return Optional.of(iconAsset);
            }
            catch (IOException e) {
                LOG.error("Error reading work item definition asset from URL [" + item.getUri() + "]", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    static String parsePath(String uri) {
        int i = uri.lastIndexOf(47);
        return i >= 0 ? uri.substring(0, i) : uri;
    }

    static String parseFileName(String uri) {
        int i = uri.lastIndexOf(47);
        return i >= 0 ? uri.substring(i + 1, uri.length()) : uri;
    }
}

