/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.definition.property.background;

import java.util.Objects;
import javax.validation.Valid;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.jboss.errai.databinding.client.api.Bindable;
import org.kie.workbench.common.forms.adf.definitions.annotations.FieldParam;
import org.kie.workbench.common.forms.adf.definitions.annotations.FormDefinition;
import org.kie.workbench.common.forms.adf.definitions.annotations.FormField;
import org.kie.workbench.common.forms.adf.definitions.settings.FieldPolicy;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.slider.type.SliderFieldType;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNPropertySet;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BgColor;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BorderColor;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BorderSize;
import org.kie.workbench.common.stunner.core.definition.annotation.Property;
import org.kie.workbench.common.stunner.core.util.HashUtil;
import org.kie.workbench.common.stunner.forms.model.ColorPickerFieldType;

@Portable
@Bindable
@FormDefinition(policy=FieldPolicy.ONLY_MARKED, startElement="bgColor")
public class BackgroundSet
implements BPMNPropertySet {
    @Property
    @FormField(type=ColorPickerFieldType.class)
    @Valid
    private BgColor bgColor;
    @Property
    @FormField(type=ColorPickerFieldType.class, afterElement="bgColor")
    @Valid
    private BorderColor borderColor;
    @Property
    @FormField(type=SliderFieldType.class, afterElement="borderColor", settings={@FieldParam(name="min", value="0.0"), @FieldParam(name="max", value="5.0"), @FieldParam(name="step", value="0.5")})
    @Valid
    private BorderSize borderSize;

    public BackgroundSet() {
        this(new BgColor(), new BorderColor(), new BorderSize());
    }

    public BackgroundSet(@MapsTo(value="bgColor") BgColor bgColor, @MapsTo(value="borderColor") BorderColor borderColor, @MapsTo(value="borderSize") BorderSize borderSize) {
        this.bgColor = bgColor;
        this.borderColor = borderColor;
        this.borderSize = borderSize;
    }

    public BackgroundSet(String bgColor, String borderColor, Double borderSize) {
        this.bgColor = new BgColor(bgColor);
        this.borderColor = new BorderColor(borderColor);
        this.borderSize = new BorderSize(borderSize);
    }

    public BgColor getBgColor() {
        return this.bgColor;
    }

    public BorderColor getBorderColor() {
        return this.borderColor;
    }

    public BorderSize getBorderSize() {
        return this.borderSize;
    }

    public void setBgColor(BgColor bgColor) {
        this.bgColor = bgColor;
    }

    public void setBorderColor(BorderColor borderColor) {
        this.borderColor = borderColor;
    }

    public void setBorderSize(BorderSize borderSize) {
        this.borderSize = borderSize;
    }

    public int hashCode() {
        return HashUtil.combineHashCodes((int[])new int[]{Objects.hashCode(this.bgColor), Objects.hashCode(this.borderColor), Objects.hashCode(this.borderSize)});
    }

    public boolean equals(Object o) {
        if (o instanceof BackgroundSet) {
            BackgroundSet other = (BackgroundSet)o;
            return Objects.equals(this.bgColor, other.bgColor) && Objects.equals(this.borderColor, other.borderColor) && Objects.equals(this.borderSize, other.borderSize);
        }
        return false;
    }
}

