/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.definition.property.diagram.imports;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.jboss.errai.databinding.client.api.Bindable;

@Portable
@Bindable
public class WSDLImport {
    protected static final String DELIMITER = "|";
    protected static final String IDENTIFIER = "wsdl";
    private String location = null;
    private String namespace = null;

    public WSDLImport() {
    }

    public WSDLImport(@MapsTo(value="location") String location, @MapsTo(value="namespace") String namespace) {
        this.location = location;
        this.namespace = namespace;
    }

    public static Boolean isValidString(String importValue) {
        String[] importParts = WSDLImport.splitImportString(importValue);
        if (importParts.length != 3) {
            return false;
        }
        if (!importParts[0].equals(IDENTIFIER)) {
            return false;
        }
        if (importParts[1].isEmpty()) {
            return false;
        }
        if (importParts[2].isEmpty()) {
            return false;
        }
        return true;
    }

    public static WSDLImport fromString(String importValue) throws Exception {
        if (!WSDLImport.isValidString(importValue).booleanValue()) {
            throw new Exception("The value: " + importValue + " is not a valid WSDL Import.");
        }
        String[] importParts = WSDLImport.splitImportString(importValue);
        WSDLImport wsdlImport = new WSDLImport(importParts[1], importParts[2]);
        return wsdlImport;
    }

    private static String[] splitImportString(String importValue) {
        return importValue.split("\\|");
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String toString() {
        if (this.location == null || this.namespace == null || this.location.isEmpty() || this.namespace.isEmpty()) {
            return "";
        }
        return "wsdl|" + this.location + DELIMITER + this.namespace;
    }
}

