/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.service;

import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.model.Module;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceRuntimeManager;
import org.kie.workbench.common.screens.datasource.management.backend.core.DeploymentOptions;
import org.kie.workbench.common.screens.datasource.management.backend.core.UnDeploymentOptions;
import org.kie.workbench.common.screens.datasource.management.backend.service.DataSourceServicesHelper;
import org.kie.workbench.common.screens.datasource.management.model.Def;
import org.kie.workbench.common.screens.datasource.management.model.DefEditorContent;
import org.kie.workbench.common.screens.datasource.management.model.DeploymentInfo;
import org.kie.workbench.common.screens.datasource.management.util.MavenArtifactResolver;
import org.kie.workbench.common.screens.datasource.management.util.UUIDGenerator;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.service.PathNamingService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public abstract class AbstractDefEditorService<C extends DefEditorContent<D>, D extends Def, I extends DeploymentInfo> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDefEditorService.class);
    protected DataSourceRuntimeManager runtimeManager;
    protected DataSourceServicesHelper serviceHelper;
    protected IOService ioService;
    protected KieModuleService moduleService;
    protected CommentedOptionFactory optionsFactory;
    protected PathNamingService pathNamingService;
    protected MavenArtifactResolver artifactResolver;

    public AbstractDefEditorService() {
    }

    public AbstractDefEditorService(DataSourceRuntimeManager runtimeManager, DataSourceServicesHelper serviceHelper, IOService ioService, KieModuleService moduleService, CommentedOptionFactory optionsFactory, PathNamingService pathNamingService, MavenArtifactResolver artifactResolver) {
        this.runtimeManager = runtimeManager;
        this.serviceHelper = serviceHelper;
        this.ioService = ioService;
        this.moduleService = moduleService;
        this.optionsFactory = optionsFactory;
        this.pathNamingService = pathNamingService;
        this.artifactResolver = artifactResolver;
    }

    protected abstract C newContent();

    protected abstract String serializeDef(D var1);

    protected abstract D deserializeDef(String var1);

    protected abstract I readDeploymentInfo(String var1) throws Exception;

    protected abstract void deploy(D var1, DeploymentOptions var2) throws Exception;

    protected abstract void unDeploy(I var1, UnDeploymentOptions var2) throws Exception;

    protected abstract void fireCreateEvent(D var1, Module var2);

    protected abstract void fireCreateEvent(D var1);

    protected abstract void fireUpdateEvent(D var1, Module var2, D var3);

    protected abstract void fireDeleteEvent(D var1, Module var2);

    protected abstract String buildFileName(D var1);

    public C loadContent(org.uberfire.backend.vfs.Path path) {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        C editorContent = this.newContent();
        String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
        D def = this.deserializeDef(content);
        editorContent.setDef(def);
        editorContent.setModule(this.moduleService.resolveModule(path));
        return editorContent;
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path path, C editorContent, String comment) {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        PortablePreconditions.checkNotNull((String)"content", editorContent);
        org.uberfire.backend.vfs.Path newPath = path;
        boolean onBatch = false;
        try {
            D originalDef = this.deserializeDef(this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path)));
            String content = this.serializeDef(editorContent.getDef());
            I deploymentInfo = this.readDeploymentInfo(editorContent.getDef().getUuid());
            if (deploymentInfo != null) {
                this.unDeploy(deploymentInfo, UnDeploymentOptions.forcedUnDeployment());
            }
            this.deploy(editorContent.getDef(), DeploymentOptions.create());
            Path _path = Paths.convert((org.uberfire.backend.vfs.Path)path);
            this.ioService.startBatch(_path.getFileSystem());
            onBatch = true;
            this.serviceHelper.getDefRegistry().invalidateCache(path);
            this.ioService.write(_path, content, new OpenOption[]{this.optionsFactory.makeCommentedOption(comment)});
            if (originalDef.getName() != null && !originalDef.getName().equals(editorContent.getDef().getName())) {
                Path _target = Paths.convert((org.uberfire.backend.vfs.Path)this.pathNamingService.buildTargetPath(path, editorContent.getDef().getName()));
                this.ioService.move(_path, _target, new CopyOption[]{this.optionsFactory.makeCommentedOption(comment)});
                newPath = Paths.convert((Path)_target);
            }
            this.serviceHelper.getDefRegistry().setEntry(newPath, editorContent.getDef());
            this.fireUpdateEvent(editorContent.getDef(), editorContent.getModule(), originalDef);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            if (onBatch) {
                this.ioService.endBatch();
            }
        }
        return newPath;
    }

    public org.uberfire.backend.vfs.Path create(D def, Module module) {
        PortablePreconditions.checkNotNull((String)"def", def);
        PortablePreconditions.checkNotNull((String)"module", (Object)module);
        org.uberfire.backend.vfs.Path context = this.serviceHelper.getModuleDataSourcesContext(module);
        org.uberfire.backend.vfs.Path newPath = this.create(def, context);
        this.fireCreateEvent(def, module);
        return newPath;
    }

    public org.uberfire.backend.vfs.Path createGlobal(D def) {
        PortablePreconditions.checkNotNull((String)"def", def);
        org.uberfire.backend.vfs.Path context = this.serviceHelper.getGlobalDataSourcesContext();
        org.uberfire.backend.vfs.Path newPath = this.create(def, context);
        this.fireCreateEvent(def);
        return newPath;
    }

    protected org.uberfire.backend.vfs.Path create(D def, org.uberfire.backend.vfs.Path context) {
        PortablePreconditions.checkNotNull((String)"def", def);
        PortablePreconditions.checkNotNull((String)"context", (Object)context);
        if (def.getUuid() == null) {
            def.setUuid(UUIDGenerator.generateUUID());
        }
        String fileName = this.buildFileName(def);
        String content = this.serializeDef(def);
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName);
        org.uberfire.backend.vfs.Path newPath = Paths.convert((Path)nioPath);
        if (this.ioService.exists(nioPath)) {
            throw new FileAlreadyExistsException(nioPath.toString());
        }
        try {
            this.ioService.startBatch(nioPath.getFileSystem());
            this.ioService.write(nioPath, content, new OpenOption[]{this.optionsFactory.makeCommentedOption("")});
            this.serviceHelper.getDefRegistry().setEntry(newPath, def);
        }
        catch (Exception e) {
            logger.error("It was not possible to create: " + def.getName(), (Throwable)e);
            this.ioService.endBatch();
            throw ExceptionUtilities.handleException((Exception)e);
        }
        try {
            this.deploy(def, DeploymentOptions.create());
        }
        catch (Exception e1) {
            logger.error("It was not possible to create: " + def.getName(), (Throwable)e1);
            this.serviceHelper.getDefRegistry().invalidateCache(newPath);
            try {
                this.ioService.delete(nioPath, new DeleteOption[0]);
            }
            catch (Exception e2) {
                logger.warn("Removal of orphan definition file failed: " + newPath, (Throwable)e2);
            }
            throw ExceptionUtilities.handleException((Exception)e1);
        }
        finally {
            this.ioService.endBatch();
        }
        return newPath;
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        if (this.ioService.exists(nioPath)) {
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            D def = this.deserializeDef(content);
            Module module = this.moduleService.resolveModule(path);
            try {
                I deploymentInfo = this.readDeploymentInfo(def.getUuid());
                if (deploymentInfo != null) {
                    this.unDeploy(deploymentInfo, UnDeploymentOptions.forcedUnDeployment());
                }
                this.serviceHelper.getDefRegistry().invalidateCache(path);
                this.ioService.delete(Paths.convert((org.uberfire.backend.vfs.Path)path), new DeleteOption[]{this.optionsFactory.makeCommentedOption(comment)});
                this.fireDeleteEvent(def, module);
            }
            catch (Exception e) {
                throw ExceptionUtilities.handleException((Exception)e);
            }
        }
    }
}

