/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener.interceptor;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedModifyDNRequest;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedModifyDNResult;
import com.unboundid.ldap.listener.interceptor.InterceptedOperation;
import com.unboundid.ldap.protocol.ModifyDNRequestProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyDNRequest;
import com.unboundid.util.Mutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
final class InterceptedModifyDNOperation
extends InterceptedOperation
implements InMemoryInterceptedModifyDNRequest,
InMemoryInterceptedModifyDNResult {
    private ModifyDNRequest modifyDNRequest;
    private LDAPResult modifyDNResult;

    InterceptedModifyDNOperation(LDAPListenerClientConnection clientConnection, int messageID, ModifyDNRequestProtocolOp requestOp, Control ... requestControls) {
        super(clientConnection, messageID);
        this.modifyDNRequest = requestOp.toModifyDNRequest(requestControls);
        this.modifyDNResult = null;
    }

    public ReadOnlyModifyDNRequest getRequest() {
        return this.modifyDNRequest;
    }

    public void setRequest(ModifyDNRequest modifyDNRequest) {
        this.modifyDNRequest = modifyDNRequest;
    }

    public LDAPResult getResult() {
        return this.modifyDNResult;
    }

    public void setResult(LDAPResult modifyDNResult) {
        this.modifyDNResult = modifyDNResult;
    }

    public void toString(StringBuilder buffer) {
        buffer.append("InterceptedModifyDNOperation(");
        this.appendCommonToString(buffer);
        buffer.append(", request=");
        buffer.append(this.modifyDNRequest);
        buffer.append(", result=");
        buffer.append(this.modifyDNResult);
        buffer.append(')');
    }
}

