/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.editors.types;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;

public class BuiltInTypeUtils {
    public static boolean isBuiltInType(String type) {
        return BuiltInTypeUtils.builtInTypeNames().anyMatch(builtInTypeName -> Objects.equals(builtInTypeName, type));
    }

    public static Optional<BuiltInType> findBuiltInTypeByName(String name) {
        return BuiltInTypeUtils.getBuiltInTypeValuesStream().filter(builtInType -> Arrays.asList(builtInType.getNames()).contains(name)).findAny();
    }

    private static Stream<String> builtInTypeNames() {
        return BuiltInTypeUtils.getBuiltInTypeValuesStream().map(BuiltInType::getNames).flatMap(Arrays::stream);
    }

    private static Stream<BuiltInType> getBuiltInTypeValuesStream() {
        return Stream.of(BuiltInType.values());
    }
}

