/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.lookup;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.workbench.common.stunner.core.lookup.LookupManager;
import org.kie.workbench.common.stunner.core.lookup.LookupResponseImpl;

public abstract class AbstractLookupManager<I, T, R extends LookupManager.LookupRequest>
implements LookupManager<T, R> {
    protected abstract List<I> getItems(R var1);

    protected abstract boolean matches(String var1, I var2);

    protected abstract T buildResult(I var1);

    @Override
    public LookupManager.LookupResponse<T> lookup(R request) {
        List<I> items = this.getItems(request);
        if (null != items && !items.isEmpty()) {
            int page = request.getPage();
            int pageSize = request.getPageSize();
            int from = page * pageSize;
            String criteria = request.getCriteria();
            LinkedList<I> result = new LinkedList<I>();
            for (I item : items) {
                if (!this.matches(criteria, item)) continue;
                result.add(item);
            }
            if (result.size() < from) {
                throw new IllegalArgumentException("Specified lookup request page [" + from + "] cannot be used, as there are no many results.");
            }
            int to = result.size() < from + pageSize ? result.size() : from + pageSize;
            List representations = result.subList(from, to).stream().map(this::buildResult).collect(Collectors.toList());
            return new LookupResponseImpl(representations, representations.size(), items.size() > to, request.getCriteria(), request.getPage(), request.getPageSize());
        }
        return this.buildEmptyResponse(request);
    }

    protected LookupManager.LookupResponse<T> buildEmptyResponse(R request) {
        return new LookupResponseImpl(new ArrayList(), 0, false, request.getCriteria(), request.getPage(), request.getPageSize());
    }
}

