/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.jbpm.server.service.formGeneration.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.kie.workbench.common.forms.adf.definitions.settings.ColSpan;
import org.kie.workbench.common.forms.adf.engine.shared.formGeneration.layout.LayoutGenerator;
import org.kie.workbench.common.forms.adf.service.definitions.layout.LayoutColumnDefinition;
import org.kie.workbench.common.forms.adf.service.definitions.layout.LayoutSettings;
import org.kie.workbench.common.forms.data.modeller.model.DataObjectFormModel;
import org.kie.workbench.common.forms.data.modeller.service.ext.ModelReaderService;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.relations.EntityRelationField;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.relations.HasNestedForm;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.relations.IsCRUDDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.relations.TableColumnMeta;
import org.kie.workbench.common.forms.jbpm.model.authoring.JBPMFormModel;
import org.kie.workbench.common.forms.jbpm.model.authoring.task.TaskFormModel;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.BPMNFormGeneratorService;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.FormGenerationResult;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.impl.GenerationContext;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.model.FormModel;
import org.kie.workbench.common.forms.service.shared.FieldManager;
import org.kie.workbench.common.forms.services.backend.util.UIDGenerator;
import org.uberfire.ext.layout.editor.api.editor.LayoutColumn;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.api.editor.LayoutRow;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;

public abstract class AbstractBPMNFormGeneratorService<SOURCE>
implements BPMNFormGeneratorService<SOURCE> {
    protected static final Collection<String> bannedModelTypes = new ArrayList<String>();
    private static final String HTML_COMPONENT = "org.uberfire.ext.plugin.client.perspective.editor.layout.editor.HTMLLayoutDragComponent";
    private static final String HTML_CODE_PARAMETER = "HTML_CODE";
    private static final String INPUTS = "<h3>Inputs:</h3>";
    private static final String OUTPUTS = "<h3>Outputs:</h3>";
    protected ModelReaderService<SOURCE> modelReaderService;
    protected FieldManager fieldManager;
    private Set<String> checkCircularSet = new HashSet<String>();

    public AbstractBPMNFormGeneratorService(ModelReaderService<SOURCE> modelReaderService, FieldManager fieldManager) {
        this.modelReaderService = modelReaderService;
        this.fieldManager = fieldManager;
    }

    @Override
    public FormGenerationResult generateForms(JBPMFormModel formModel, SOURCE source) {
        if (formModel == null) {
            throw new IllegalArgumentException("FormModel cannot be null");
        }
        GenerationContext<SOURCE> context = new GenerationContext<SOURCE>(formModel, source, this.modelReaderService.getModelReader(source));
        FormDefinition rootForm = this.createRootFormDefinition(context);
        if (rootForm == null) {
            throw new IllegalStateException("Impossible to generate form for: " + formModel.getFormName());
        }
        this.processFormDefinition(rootForm, context);
        if (rootForm.getLayoutTemplate() == null) {
            this.createFormLayout(rootForm);
        }
        context.setRootForm(rootForm);
        return new FormGenerationResult(context.getRootForm(), new ArrayList<FormDefinition>(context.getContextForms().values()));
    }

    protected void createFormLayout(FormDefinition form) {
        LayoutGenerator layoutGenerator = new LayoutGenerator();
        layoutGenerator.init(new LayoutColumnDefinition[]{new LayoutColumnDefinition(ColSpan.SPAN_12)});
        if (form.getFields().size() > 0) {
            boolean separeateInputsAndOutputs = form.getModel() instanceof TaskFormModel;
            boolean mightAddOtuputsLabel = ((FieldDefinition)form.getFields().get(0)).getReadOnly();
            if (separeateInputsAndOutputs) {
                if (mightAddOtuputsLabel) {
                    layoutGenerator.addComponent(this.generateHTMLElement(INPUTS), new LayoutSettings());
                } else {
                    layoutGenerator.addComponent(this.generateHTMLElement(OUTPUTS), new LayoutSettings());
                }
            }
            for (FieldDefinition fieldDefinition : form.getFields()) {
                if (separeateInputsAndOutputs && mightAddOtuputsLabel && !fieldDefinition.getReadOnly().booleanValue()) {
                    mightAddOtuputsLabel = false;
                    layoutGenerator.addComponent(this.generateHTMLElement(OUTPUTS), new LayoutSettings());
                }
                LayoutComponent fieldComponent = new LayoutComponent("org.kie.workbench.common.forms.editor.client.editor.rendering.EditorFieldLayoutComponent");
                fieldComponent.addProperty("form_id", form.getId());
                fieldComponent.addProperty("field_id", fieldDefinition.getId());
                layoutGenerator.addComponent(fieldComponent, new LayoutSettings());
            }
        }
        form.setLayoutTemplate(layoutGenerator.build());
    }

    protected LayoutComponent generateHTMLElement(String content) {
        LayoutComponent htmlComponent = new LayoutComponent(HTML_COMPONENT);
        htmlComponent.addProperty(HTML_CODE_PARAMETER, content);
        return htmlComponent;
    }

    protected void processFormDefinition(FormDefinition formDefinition, GenerationContext<SOURCE> context) {
        List fieldsToRemove = formDefinition.getFields().stream().filter(field -> !this.processFieldDefinition((FieldDefinition)field, context)).collect(Collectors.toList());
        fieldsToRemove.stream().forEach(fieldDefinition -> this.removeField((FieldDefinition)fieldDefinition, formDefinition));
    }

    private void removeField(FieldDefinition fieldDefinition, FormDefinition formDefinition) {
        LayoutRow row2;
        Optional<LayoutColumn> optionalColumn;
        Optional<LayoutRow> optionalRow;
        formDefinition.getFields().remove(fieldDefinition);
        LayoutTemplate layout = formDefinition.getLayoutTemplate();
        if (layout != null && (optionalRow = layout.getRows().stream().filter(row -> this.rowContainsField((LayoutRow)row, fieldDefinition)).findAny()).isPresent() && (optionalColumn = this.getFieldColumn(row2 = optionalRow.get(), fieldDefinition)).isPresent()) {
            LayoutColumn column = optionalColumn.get();
            LayoutComponent component = this.getFieldComponent(column, fieldDefinition).get();
            column.getLayoutComponents().remove(component);
            if (column.getLayoutComponents().isEmpty()) {
                row2.getLayoutColumns().remove(column);
                if (row2.getLayoutColumns().isEmpty()) {
                    layout.getRows().remove(row2);
                } else {
                    int span = Integer.decode(column.getSpan());
                    LayoutColumn firstColumn = (LayoutColumn)row2.getLayoutColumns().get(0);
                    int fistSpan = Integer.decode(firstColumn.getSpan());
                    LayoutColumn newFirstColumn = new LayoutColumn(String.valueOf(span + fistSpan), firstColumn.getHeight(), firstColumn.getProperties());
                    firstColumn.getLayoutComponents().forEach(arg_0 -> ((LayoutColumn)newFirstColumn).add(arg_0));
                    firstColumn.getRows().forEach(arg_0 -> ((LayoutColumn)newFirstColumn).addRow(arg_0));
                    Collections.replaceAll(row2.getLayoutColumns(), firstColumn, newFirstColumn);
                }
            }
        }
    }

    protected boolean rowContainsField(LayoutRow row, FieldDefinition fieldDefinition) {
        if (!row.getLayoutColumns().isEmpty()) {
            return this.getFieldColumn(row, fieldDefinition).isPresent();
        }
        return false;
    }

    protected Optional<LayoutColumn> getFieldColumn(LayoutRow row, FieldDefinition fieldDefinition) {
        return row.getLayoutColumns().stream().filter(column -> this.getFieldComponent((LayoutColumn)column, fieldDefinition).isPresent()).findAny();
    }

    protected Optional<LayoutComponent> getFieldComponent(LayoutColumn column, FieldDefinition fieldDefinition) {
        return column.getLayoutComponents().stream().filter(component -> fieldDefinition.getId().equals(component.getProperties().get("field_id"))).findAny();
    }

    private boolean hasCyclicReference(String modelType) {
        if (bannedModelTypes.contains(modelType)) {
            throw new IllegalArgumentException("Cannot extract fields for '" + modelType + "'");
        }
        if (this.checkCircularSet.contains(modelType)) {
            return true;
        }
        this.checkCircularSet.add(modelType);
        return false;
    }

    protected boolean processFieldDefinition(FieldDefinition field, GenerationContext<SOURCE> context) {
        if (field instanceof EntityRelationField) {
            try {
                if (this.hasCyclicReference(field.getStandaloneClassName())) {
                    return false;
                }
                if (field instanceof HasNestedForm) {
                    HasNestedForm nestedFormField = (HasNestedForm)field;
                    FormDefinition nestedForm = this.findFormDefinitionForModelType(field.getStandaloneClassName(), context);
                    if (nestedForm == null) {
                        nestedForm = this.createModelFormDefinition(field.getStandaloneClassName(), context);
                        this.verifyNestedForm(nestedForm, context);
                    }
                    nestedFormField.setNestedForm(nestedForm.getId());
                } else if (field instanceof IsCRUDDefinition) {
                    IsCRUDDefinition crudField = (IsCRUDDefinition)field;
                    FormDefinition nestedForm = this.findFormDefinitionForModelType(field.getStandaloneClassName(), context);
                    if (nestedForm == null) {
                        nestedForm = this.createModelFormDefinition(field.getStandaloneClassName(), context);
                        this.verifyNestedForm(nestedForm, context);
                        crudField.setCreationForm(nestedForm.getId());
                        crudField.setEditionForm(nestedForm.getId());
                        ArrayList tableColumnMetas = new ArrayList();
                        nestedForm.getFields().forEach(nestedField -> tableColumnMetas.add(new TableColumnMeta(nestedField.getLabel(), nestedField.getBinding())));
                        crudField.setColumnMetas(tableColumnMetas);
                    }
                }
                this.checkCircularSet.clear();
            }
            catch (Exception ex) {
                this.log("Something wrong happened processing FieldDefinition '" + field.getName() + "\"", ex);
                return false;
            }
        }
        return true;
    }

    private void verifyNestedForm(FormDefinition nestedForm, GenerationContext<SOURCE> context) {
        if (nestedForm != null && nestedForm.getFields().isEmpty() && !this.supportsEmptyNestedForms()) {
            if (nestedForm != null) {
                context.getContextForms().remove(nestedForm.getId());
            }
            throw new RuntimeException("Not Supported empty Nested forms");
        }
    }

    protected FormDefinition createModelFormDefinition(String modelType, GenerationContext<SOURCE> context) {
        Optional<FormDefinition> optional = Optional.ofNullable(context.getContextForms().get(modelType));
        return optional.orElseGet(() -> this.createNewFormDefinition(modelType, context));
    }

    private FormDefinition createNewFormDefinition(String modelType, GenerationContext<SOURCE> context) {
        if (bannedModelTypes.contains(modelType)) {
            throw new IllegalArgumentException("Cannot extract fields for '" + modelType + "'");
        }
        DataObjectFormModel formModel = context.getModelReader().readFormModel(modelType);
        FormDefinition form = new FormDefinition((FormModel)formModel);
        form.setId(UIDGenerator.generateUID());
        form.setName(AbstractBPMNFormGeneratorService.generateNestedFormName(formModel.getType()));
        formModel.getProperties().forEach(property -> form.getFields().add(this.fieldManager.getDefinitionByModelProperty(property)));
        List fieldsToRemove = form.getFields().stream().filter(field -> !this.processFieldDefinition((FieldDefinition)field, context)).collect(Collectors.toList());
        form.getFields().removeAll(fieldsToRemove);
        this.createFormLayout(form);
        context.getContextForms().put(modelType, form);
        return form;
    }

    public static String generateNestedFormName(String className) {
        return className.replaceAll("\\.", "_");
    }

    protected abstract boolean supportsEmptyNestedForms();

    protected abstract FormDefinition createRootFormDefinition(GenerationContext<SOURCE> var1);

    protected abstract void log(String var1, Exception var2);

    protected FormDefinition findFormDefinitionForModelType(String modelType, GenerationContext<SOURCE> context) {
        return context.getContextForms().get(modelType);
    }

    static {
        bannedModelTypes.add(Object.class.getName());
    }
}

