/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.jbpm.server.service.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.MultiInstanceLoopCharacteristics;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.UserTask;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jsoup.parser.Parser;
import org.kie.workbench.common.forms.jbpm.model.authoring.process.BusinessProcessFormModel;
import org.kie.workbench.common.forms.jbpm.model.authoring.task.TaskFormModel;
import org.kie.workbench.common.forms.jbpm.server.service.BPMNFormModelGenerator;
import org.kie.workbench.common.forms.jbpm.server.service.impl.ProcessTaskFormsGenerationResult;
import org.kie.workbench.common.forms.jbpm.server.service.impl.TaskFormVariables;
import org.kie.workbench.common.forms.jbpm.server.service.impl.Variable;
import org.kie.workbench.common.forms.jbpm.service.bpmn.util.BPMNVariableUtils;
import org.kie.workbench.common.forms.model.ModelProperty;
import org.kie.workbench.common.services.backend.project.ModuleClassLoaderHelper;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.Path;

@Dependent
public class BPMNFormModelGeneratorImpl
implements BPMNFormModelGenerator {
    private static final Logger logger = LoggerFactory.getLogger(BPMNFormModelGeneratorImpl.class);
    private KieModuleService moduleService;
    private ModuleClassLoaderHelper projectClassLoaderHelper;

    @Inject
    public BPMNFormModelGeneratorImpl(KieModuleService moduleService, ModuleClassLoaderHelper projectClassLoaderHelper) {
        this.moduleService = moduleService;
        this.projectClassLoaderHelper = projectClassLoaderHelper;
    }

    @Override
    public BusinessProcessFormModel generateProcessFormModel(Definitions source, Path path) {
        Process process = this.getProcess(source);
        if (process != null) {
            ClassLoader projectClassLoader = this.projectClassLoaderHelper.getModuleClassLoader((KieModule)this.moduleService.resolveModule(path));
            List properties = process.getProperties().stream().map(property -> {
                String varName = property.getId();
                String varType = BPMNVariableUtils.getRealTypeForInput((String)property.getItemSubjectRef().getStructureRef());
                Variable variable = new Variable(varName, varType);
                variable.setInput(true);
                variable.setOutput(true);
                return this.createModelProperty(variable, projectClassLoader);
            }).filter(modelProperty -> modelProperty != null).sorted((property1, property2) -> property1.getName().compareToIgnoreCase(property2.getName())).collect(Collectors.toList());
            return new BusinessProcessFormModel(process.getId(), process.getName(), properties);
        }
        return null;
    }

    @Override
    public List<TaskFormModel> generateTaskFormModels(Definitions source, Path path) {
        Process process = this.getProcess(source);
        ClassLoader projectClassLoader = this.projectClassLoaderHelper.getModuleClassLoader((KieModule)this.moduleService.resolveModule(path));
        if (process != null) {
            ProcessTaskFormsGenerationResult result = this.readUserTaskFormVariables((FlowElementsContainer)process);
            return result.getAllTaskFormVariables().stream().filter(taskFormVariables -> {
                if (!taskFormVariables.isValid()) {
                    logger.warn(this.generateErrorMessage((TaskFormVariables)taskFormVariables));
                    return false;
                }
                return true;
            }).map(taskFormVariables -> taskFormVariables.toFormModel(variable -> this.createModelProperty((Variable)variable, projectClassLoader))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected ModelProperty createModelProperty(Variable variable, ClassLoader classLoader) {
        return BPMNVariableUtils.generateVariableProperty((String)variable.getName(), (String)variable.getType(), (variable.isInput() && !variable.isOutput() ? 1 : 0) != 0, (ClassLoader)classLoader);
    }

    @Override
    public TaskFormModel generateTaskFormModel(Definitions source, String taskId, Path path) {
        ProcessTaskFormsGenerationResult generationResult;
        Optional<TaskFormVariables> resultTaskFormVariables;
        Process process = this.getProcess(source);
        if (process != null && (resultTaskFormVariables = Optional.ofNullable((generationResult = this.readUserTaskFormVariables((FlowElementsContainer)process)).getTaskFormVariablesByTaskId(taskId))).isPresent()) {
            TaskFormVariables formVariables = resultTaskFormVariables.get();
            if (!formVariables.isValid()) {
                throw new IllegalStateException(this.generateErrorMessage(formVariables));
            }
            ClassLoader projectClassLoader = this.projectClassLoaderHelper.getModuleClassLoader((KieModule)this.moduleService.resolveModule(path));
            return formVariables.toFormModel(variable -> this.createModelProperty((Variable)variable, projectClassLoader));
        }
        return null;
    }

    private String generateErrorMessage(TaskFormVariables formVariables) {
        StringBuffer buffer = new StringBuffer("Unable to generate form '").append(formVariables.getTaskName()).append("'. Errors found:");
        formVariables.getErrors().forEach(message -> buffer.append("\n").append((String)message));
        buffer.append("\n").append("Please check your task definitions.");
        return buffer.toString();
    }

    private ProcessTaskFormsGenerationResult readUserTaskFormVariables(FlowElementsContainer container) {
        ProcessTaskFormsGenerationResult result = new ProcessTaskFormsGenerationResult(container.getId());
        this.readUserTaskFormVariables(container, result);
        return result;
    }

    private void readUserTaskFormVariables(FlowElementsContainer container, ProcessTaskFormsGenerationResult result) {
        container.getFlowElements().stream().filter(flowElement -> flowElement instanceof UserTask).map(flowElement -> (UserTask)flowElement).forEach(userTask -> this.readTaskVariables((UserTask)userTask, result));
        container.getFlowElements().stream().filter(flowElement -> flowElement instanceof FlowElementsContainer).map(flowElement -> (FlowElementsContainer)flowElement).forEach(flowElementsContainer -> this.readUserTaskFormVariables((FlowElementsContainer)flowElementsContainer, result));
    }

    protected void readTaskVariables(UserTask userTask, ProcessTaskFormsGenerationResult result) {
        List dataOutputAssociations;
        TaskFormVariables formVariables = new TaskFormVariables(userTask);
        List dataInputAssociations = userTask.getDataInputAssociations();
        if (dataInputAssociations != null) {
            for (DataInputAssociation inputAssociation : dataInputAssociations) {
                if (inputAssociation.getTargetRef() == null || BPMNFormModelGeneratorImpl.isMIInputCollection(userTask, inputAssociation)) continue;
                String name = ((DataInput)inputAssociation.getTargetRef()).getName();
                if (BPMNVariableUtils.isValidInputName((String)name)) {
                    String type = BPMNFormModelGeneratorImpl.extractInputType(inputAssociation);
                    type = BPMNVariableUtils.getRealTypeForInput((String)type);
                    Variable variable = new Variable(name, type);
                    variable.setInput(true);
                    formVariables.addVariable(variable);
                    continue;
                }
                if (!"TaskName".equals(name)) continue;
                List assignments = inputAssociation.getAssignment();
                Iterator it = assignments.iterator();
                while (it.hasNext() && StringUtils.isEmpty((CharSequence)formVariables.getTaskName())) {
                    String taskName;
                    Assignment assignment = (Assignment)it.next();
                    if (assignment.getFrom() == null || StringUtils.isEmpty((CharSequence)(taskName = ((FormalExpression)assignment.getFrom()).getBody()))) continue;
                    taskName = Parser.xmlParser().parseInput(taskName, "").text();
                    formVariables.setTaskName(taskName);
                }
            }
        }
        if ((dataOutputAssociations = userTask.getDataOutputAssociations()) != null) {
            dataOutputAssociations.forEach(outputAssociation -> {
                if (outputAssociation.getSourceRef() != null && outputAssociation.getSourceRef().size() == 1 && !BPMNFormModelGeneratorImpl.isMIOutputCollection(userTask, outputAssociation)) {
                    DataOutput output = (DataOutput)outputAssociation.getSourceRef().get(0);
                    String name = output.getName();
                    String type = BPMNFormModelGeneratorImpl.extractOutputType(output);
                    type = BPMNVariableUtils.getRealTypeForInput((String)type);
                    Variable variable = new Variable(name, type);
                    variable.setOutput(true);
                    formVariables.addVariable(variable);
                }
            });
        }
        if (!StringUtils.isEmpty((CharSequence)formVariables.getTaskName())) {
            result.registerTaskFormVariables(userTask.getId(), formVariables);
        } else {
            logger.warn("Cannot generate a form for task '{}' since it has no form name.", (Object)userTask.getName());
        }
    }

    @Override
    public Process getProcess(Definitions source) {
        for (RootElement re : source.getRootElements()) {
            if (!(re instanceof Process)) continue;
            return (Process)re;
        }
        return null;
    }

    private static String extractInputType(DataInputAssociation inputAssociation) {
        if (inputAssociation.getTargetRef() != null && inputAssociation.getTargetRef().getItemSubjectRef() != null) {
            return inputAssociation.getTargetRef().getItemSubjectRef().getStructureRef();
        }
        if (inputAssociation.getTargetRef() != null && inputAssociation.getTargetRef().getAnyAttribute() != null && !inputAssociation.getTargetRef().getAnyAttribute().isEmpty()) {
            return ((FeatureMap.Entry)inputAssociation.getTargetRef().getAnyAttribute().get(0)).getValue().toString();
        }
        return null;
    }

    private static String extractOutputType(DataOutput output) {
        if (output.getItemSubjectRef() != null) {
            return output.getItemSubjectRef().getStructureRef();
        }
        if (output.getAnyAttribute() != null && !output.getAnyAttribute().isEmpty()) {
            return ((FeatureMap.Entry)output.getAnyAttribute().get(0)).getValue().toString();
        }
        return null;
    }

    private static boolean isMIInputCollection(UserTask userTask, DataInputAssociation inputAssociation) {
        String inputCollectionRef;
        MultiInstanceLoopCharacteristics loopCharacteristics = (MultiInstanceLoopCharacteristics)userTask.getLoopCharacteristics();
        String string = inputCollectionRef = loopCharacteristics != null ? BPMNFormModelGeneratorImpl.getId((BaseElement)loopCharacteristics.getLoopDataInputRef()) : null;
        if (StringUtils.isEmpty((CharSequence)inputCollectionRef)) {
            return false;
        }
        String associationTargetRef = BPMNFormModelGeneratorImpl.getId((BaseElement)inputAssociation.getTargetRef());
        return inputCollectionRef.equals(associationTargetRef);
    }

    private static boolean isMIOutputCollection(UserTask userTask, DataOutputAssociation outputAssociation) {
        String outputCollectionRef;
        MultiInstanceLoopCharacteristics loopCharacteristics = (MultiInstanceLoopCharacteristics)userTask.getLoopCharacteristics();
        String string = outputCollectionRef = loopCharacteristics != null ? BPMNFormModelGeneratorImpl.getId((BaseElement)loopCharacteristics.getLoopDataOutputRef()) : null;
        if (StringUtils.isEmpty((CharSequence)outputCollectionRef)) {
            return false;
        }
        String associationSourceRef = outputAssociation.getSourceRef() != null && !outputAssociation.getSourceRef().isEmpty() ? ((ItemAwareElement)outputAssociation.getSourceRef().get(0)).getId() : null;
        return outputCollectionRef.equals(associationSourceRef);
    }

    private static String getId(BaseElement element) {
        return element != null ? element.getId() : null;
    }
}

