/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.elements;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Process;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.DroolsPackage;
import org.jboss.drools.MetaDataType;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.elements.MetaDataAttributesElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;

public class MetaDataAttributesElementTest {
    private static final String ATTRIBUTES = "att1\u00dfval1\u00d8att2\u00dfval2\u00d8att3\u00dfval3";
    private static final String ATTRIBUTE = "att1\u00dfval1";
    private static final String NAME = "metaDataElement";
    private static final String SPECIAL_CHAR_ATTRIBUTES = "att1\u00df#{[($%&@!*|)]}\u00d8att2\u00df/-_.,?`'^\"\\~<>=+\u00d8att3\u00df:;\u00e7\u00c7\u00e1\u00e0\u00c1\u00c0\u00e3\u00c3\u00fc\u00dc";

    @Test
    public void testSetValue() {
        Process baseElement = Factories.bpmn2.createProcess();
        CustomElement.metaDataAttributes.of((BaseElement)baseElement).set((Object)ATTRIBUTES);
        Assert.assertEquals((Object)"att1\u00df<![CDATA[val1]]>\u00d8att2\u00df<![CDATA[val2]]>\u00d8att3\u00df<![CDATA[val3]]>", (Object)CustomElement.metaDataAttributes.of((BaseElement)baseElement).get());
    }

    @Test
    public void testSetValueSpecialChar() {
        Process baseElement = Factories.bpmn2.createProcess();
        CustomElement.metaDataAttributes.of((BaseElement)baseElement).set((Object)SPECIAL_CHAR_ATTRIBUTES);
        Assert.assertEquals((Object)"att1\u00df<![CDATA[#{[($%&@!*|)]}]]>\u00d8att2\u00df<![CDATA[/-_.,?`'^\"\\~<>=+]]>\u00d8att3\u00df<![CDATA[:;\u00e7\u00c7\u00e1\u00e0\u00c1\u00c0\u00e3\u00c3\u00fc\u00dc]]>", (Object)CustomElement.metaDataAttributes.of((BaseElement)baseElement).get());
    }

    @Test
    public void testGetDefaultValue() {
        Process baseElement = Factories.bpmn2.createProcess();
        Assert.assertEquals((Object)"", (Object)CustomElement.metaDataAttributes.of((BaseElement)baseElement).get());
    }

    @Test
    public void testGetStringValueNameNull() {
        Process baseElement = Factories.bpmn2.createProcess();
        CustomElement.metaDataAttributes.of((BaseElement)baseElement).set(null);
        Assert.assertEquals((Object)"", (Object)CustomElement.metaDataAttributes.of((BaseElement)baseElement).get());
    }

    @Test
    public void testGetStringValueNameEmpty() {
        Process baseElement = Factories.bpmn2.createProcess();
        CustomElement.metaDataAttributes.of((BaseElement)baseElement).set((Object)"\u00dfValue");
        Assert.assertEquals((Object)"", (Object)CustomElement.metaDataAttributes.of((BaseElement)baseElement).get());
    }

    @Test
    public void testGetStringValueEmpty() {
        Process baseElement = Factories.bpmn2.createProcess();
        CustomElement.metaDataAttributes.of((BaseElement)baseElement).set((Object)"att1");
        Assert.assertEquals((Object)"att1\u00df", (Object)CustomElement.metaDataAttributes.of((BaseElement)baseElement).get());
    }

    @Test
    public void testGetStringValueValueEmpty() {
        Process baseElement = Factories.bpmn2.createProcess();
        CustomElement.metaDataAttributes.of((BaseElement)baseElement).set((Object)"attribute\u00df\u00dfatt2");
        Assert.assertEquals((Object)"attribute\u00df<![CDATA[]]>", (Object)CustomElement.metaDataAttributes.of((BaseElement)baseElement).get());
    }

    @Test
    public void testExtensionOf() {
        MetaDataAttributesElement metaDataAttributesElement = new MetaDataAttributesElement(NAME);
        MetaDataType metaDataType = metaDataAttributesElement.metaDataTypeDataOf(ATTRIBUTE);
        FeatureMap.Entry entry = metaDataAttributesElement.extensionOf(ATTRIBUTE);
        Assert.assertNotNull((Object)entry);
        Assert.assertTrue((boolean)(entry instanceof EStructuralFeatureImpl.SimpleFeatureMapEntry));
        Assert.assertEquals((Object)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, (Object)entry.getEStructuralFeature());
        Assert.assertNotNull((Object)entry.getValue());
        Assert.assertEquals((Object)metaDataType.getName(), (Object)((MetaDataType)entry.getValue()).getName());
        Assert.assertEquals((Object)metaDataType.getMetaValue(), (Object)((MetaDataType)entry.getValue()).getMetaValue());
    }

    @Test
    public void testImportTypeDataOf() {
        MetaDataAttributesElement metaDataAttributesElement = new MetaDataAttributesElement(NAME);
        MetaDataType metaDataType = metaDataAttributesElement.metaDataTypeDataOf(ATTRIBUTE);
        Assert.assertTrue((boolean)"att1\u00df<![CDATA[val1]]>".startsWith(metaDataType.getName()));
        Assert.assertTrue((boolean)"att1\u00df<![CDATA[val1]]>".endsWith(metaDataType.getMetaValue()));
    }
}

