/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.kie.api.pmml.ParameterInfo;
import org.kie.server.api.marshalling.json.JSONMarshaller;
import org.kie.server.api.marshalling.json.JSONMarshallerExtension;

public class JSONMarshallerPMMLParamInfo
implements JSONMarshallerExtension {
    private static final PMMLParamDeserializer DESERIALIZER = new PMMLParamDeserializer();
    private static final PMMLParamSerializer SERIALIZER = new PMMLParamSerializer();

    @Override
    public void extend(JSONMarshaller marshaller, ObjectMapper serializer, ObjectMapper deserializer) {
        this.registerModule(serializer);
        this.registerModule(deserializer);
    }

    private void registerModule(ObjectMapper objectMapper) {
        SimpleModule paramInfoModule = new SimpleModule("pmml-param-info-module", Version.unknownVersion());
        paramInfoModule.addDeserializer(ParameterInfo.class, (JsonDeserializer)DESERIALIZER);
        paramInfoModule.addSerializer(ParameterInfo.class, (JsonSerializer)SERIALIZER);
        objectMapper.registerModule((Module)paramInfoModule);
    }

    private static class PMMLParamSerializer
    extends JsonSerializer<ParameterInfo> {
        private PMMLParamSerializer() {
        }

        public void serialize(ParameterInfo value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeFieldName("correlationId");
            gen.writeString(value.getCorrelationId());
            gen.writeFieldName("name");
            gen.writeString(value.getName());
            gen.writeFieldName("type");
            gen.writeString(value.getType().getName());
            gen.writeFieldName("value");
            gen.writeString(value.getValue().toString());
        }
    }

    private static class PMMLParamDeserializer
    extends JsonDeserializer<ParameterInfo> {
        private PMMLParamDeserializer() {
        }

        public ParameterInfo deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ParameterInfo pi = new ParameterInfo();
            String fldName = p.nextFieldName();
            String value = p.nextTextValue();
            return pi;
        }
    }
}

