/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.associations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ThrowEvent;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.associations.AbstractCompensationEventPostConverterTest;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.compensation.ActivityRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.compensation.CompensationEventExecutionSet;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class AbstractThrowCompensationEventPostConverterTest<T extends BPMNViewDefinition>
extends AbstractCompensationEventPostConverterTest<T, ThrowEvent> {
    protected static final String ACTIVITY_REF = "ACTIVITY_REF";
    @Mock
    protected ActivityRef activityRef;
    @Mock
    protected Activity activity;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.getExecutionSet(this.event).getActivityRef().setValue(ACTIVITY_REF);
        Mockito.when((Object)this.activity.getId()).thenReturn((Object)ACTIVITY_REF);
    }

    @Override
    public ThrowEvent createBpmn2Event(CompensateEventDefinition compensateEvent) {
        ThrowEvent throwEvent = (ThrowEvent)Mockito.mock(ThrowEvent.class);
        List<CompensateEventDefinition> eventDefinitions = Collections.singletonList(compensateEvent);
        Mockito.when((Object)throwEvent.getEventDefinitions()).thenReturn(eventDefinitions);
        return throwEvent;
    }

    public abstract CompensationEventExecutionSet getExecutionSet(T var1);

    @Test
    public void testProcessWhenActivityFound() {
        List<Activity> flowElements = Collections.singletonList(this.activity);
        Mockito.when((Object)this.process.getFlowElements()).thenReturn(flowElements);
        this.converter.process(this.processWriter, this.nodeWriter, this.node);
        ((CompensateEventDefinition)Mockito.verify((Object)this.compensateEvent)).setActivityRef(this.activity);
    }

    @Test
    public void testProcessWhenActivityNotFound() {
        ArrayList flowElements = new ArrayList();
        Mockito.when((Object)this.process.getFlowElements()).thenReturn(flowElements);
        this.converter.process(this.processWriter, this.nodeWriter, this.node);
        ((CompensateEventDefinition)Mockito.verify((Object)this.compensateEvent, (VerificationMode)Mockito.never())).setActivityRef(this.activity);
    }
}

