/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import java.util.Collection;
import java.util.Collections;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.DeregisterNodeCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.context.CardinalityContext;

@Portable
public class RegisterNodeCommand
extends AbstractGraphCommand {
    private final Node candidate;

    public RegisterNodeCommand(@MapsTo(value="candidate") Node candidate) {
        this.candidate = (Node)PortablePreconditions.checkNotNull((String)"candidate", (Object)candidate);
    }

    public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
        CommandResult<RuleViolation> results = this.allow(context);
        if (!results.getType().equals((Object)CommandResult.Type.ERROR)) {
            Graph<?, Node> graph = this.getGraph(context);
            graph.addNode(this.candidate);
            this.getMutableIndex(context).addNode(this.candidate);
        }
        return results;
    }

    @Override
    protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
        Collection<RuleViolation> cardinalityRuleViolations = this.evaluate(context, contextBuilder -> contextBuilder.cardinality(Collections.singleton(this.getCandidate()), CardinalityContext.Operation.ADD));
        return new GraphCommandResultBuilder(cardinalityRuleViolations).build();
    }

    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        DeregisterNodeCommand undoCommand = new DeregisterNodeCommand(this.candidate);
        return undoCommand.execute(context);
    }

    public Node getCandidate() {
        return this.candidate;
    }

    public String toString() {
        return "RegisterNodeCommand [candidate=" + this.candidate.getUUID() + "]";
    }
}

