/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.lookup.domain;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.registry.impl.DefinitionsCacheRegistry;
import org.kie.workbench.common.stunner.core.rule.Rule;
import org.kie.workbench.common.stunner.core.rule.RuleSet;
import org.kie.workbench.common.stunner.core.rule.impl.CanConnect;

class DomainLookupsCache {
    private final String defSetId;
    private final RuleSet ruleSet;
    private final Map<String, Set<String>> definitionsByLabel;
    private final List<CanConnect> connectionRules;

    DomainLookupsCache(DefinitionManager definitionManager, DefinitionsCacheRegistry definitionsRegistry, String defSetId) {
        this.defSetId = defSetId;
        this.definitionsByLabel = new HashMap<String, Set<String>>(200);
        Object definitionSet = definitionManager.definitionSets().getDefinitionSetById(defSetId);
        this.ruleSet = definitionManager.adapters().forRules().getRuleSet(definitionSet);
        this.connectionRules = this.ruleSet.getRules().stream().map(DomainLookupsCache::isConnectionRule).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        this.registerDefinitions(definitionManager, definitionsRegistry, definitionSet);
    }

    private static Optional<CanConnect> isConnectionRule(Rule rule) {
        return rule instanceof CanConnect ? Optional.of((CanConnect)rule) : Optional.empty();
    }

    public Set<String> getDefinitions(String label) {
        Set<String> ids = this.definitionsByLabel.get(label);
        return null != ids ? ids : Collections.emptySet();
    }

    public void clear() {
        this.definitionsByLabel.clear();
        this.connectionRules.clear();
    }

    public String getDefinitionSetId() {
        return this.defSetId;
    }

    public List<CanConnect> getConnectionRules() {
        return this.connectionRules;
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    private void registerDefinitions(DefinitionManager definitionManager, DefinitionsCacheRegistry definitionsRegistry, Object definitionSet) {
        definitionManager.adapters().forDefinitionSet().getDefinitions(definitionSet).forEach(id -> this.registerDefinition(definitionsRegistry, (String)id));
    }

    private void registerDefinition(DefinitionsCacheRegistry definitionsRegistry, String id) {
        definitionsRegistry.getLabels(id).forEach(label -> this.registerDefinition((String)label, id));
    }

    private void registerDefinition(String label, String id) {
        Set ids = this.definitionsByLabel.computeIfAbsent(label, k -> new LinkedHashSet());
        ids.add(id);
    }
}

