/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.server;

import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.security.authz.AuthorizationManager;

@WebListener
public class CleanupSecurityCacheSessionListener
implements HttpSessionListener {
    private final Collection<AuthorizationManager> authorizationManagers = new ArrayList<AuthorizationManager>();

    public CleanupSecurityCacheSessionListener() {
    }

    @Inject
    public CleanupSecurityCacheSessionListener(Instance<AuthorizationManager> authorizationManagers) {
        for (AuthorizationManager authorizationManager : authorizationManagers) {
            this.authorizationManagers.add(authorizationManager);
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        if (this.authorizationManagers.isEmpty()) {
            return;
        }
        User currentUser = (User)se.getSession().getAttribute("uf.security.user");
        if (!User.ANONYMOUS.equals(currentUser)) {
            for (AuthorizationManager authorizationManager : this.authorizationManagers) {
                authorizationManager.invalidate(currentUser);
            }
        }
    }
}

