/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import org.drools.core.process.instance.WorkItem;
import org.jbpm.process.instance.context.swimlane.SwimlaneContextInstance;
import org.jbpm.process.instance.timer.TimerInstance;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.model.Task;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumanTaskNodeInstance
extends WorkItemNodeInstance {
    public static final String ADMINISTRATOR_USER = System.getProperty("org.jbpm.ht.admin.user", "Administrator");
    public static final String SUSPEND_UNTIL_PARAMETER = "suspendUntil";
    public static final String SUSPEND_SIGNAL = "humanTaskNodeInstance:suspended";
    public static final String ACTIVATE_SIGNAL = "humanTaskNodeInstance:activated";
    private static final Logger logger = LoggerFactory.getLogger(HumanTaskNodeInstance.class);
    private static final long serialVersionUID = 510L;
    private String separator = System.getProperty("org.jbpm.ht.user.separator", ",");
    private transient SwimlaneContextInstance swimlaneContextInstance;
    private long suspendUntilTimerId = -1L;

    public HumanTaskNode getHumanTaskNode() {
        return (HumanTaskNode)this.getNode();
    }

    public long getSuspendUntilTimerId() {
        return this.suspendUntilTimerId;
    }

    public void setSuspendUntilTimerId(long suspendUntilTimerId) {
        this.suspendUntilTimerId = suspendUntilTimerId;
    }

    @Override
    protected WorkItem createWorkItem(WorkItemNode workItemNode) {
        WorkItem workItem = super.createWorkItem(workItemNode);
        String actorId = this.assignWorkItem(workItem);
        if (actorId != null) {
            workItem.setParameter("ActorId", (Object)actorId);
        }
        return workItem;
    }

    protected String assignWorkItem(WorkItem workItem) {
        String actorId = null;
        String swimlaneName = this.getHumanTaskNode().getSwimlane();
        SwimlaneContextInstance swimlaneContextInstance = this.getSwimlaneContextInstance(swimlaneName);
        if (swimlaneContextInstance != null) {
            actorId = swimlaneContextInstance.getActorId(swimlaneName);
            workItem.setParameter("SwimlaneActorId", (Object)actorId);
        }
        if (actorId == null && (actorId = (String)workItem.getParameter("ActorId")) != null && swimlaneContextInstance != null && actorId.split(this.separator).length == 1) {
            swimlaneContextInstance.setActorId(swimlaneName, actorId);
            workItem.setParameter("SwimlaneActorId", (Object)actorId);
        }
        return (String)workItem.getParameter("ActorId");
    }

    private SwimlaneContextInstance getSwimlaneContextInstance(String swimlaneName) {
        if (this.swimlaneContextInstance == null) {
            if (swimlaneName == null) {
                return null;
            }
            SwimlaneContextInstance swimlaneContextInstance = (SwimlaneContextInstance)this.resolveContextInstance("SwimlaneScope", swimlaneName);
            if (swimlaneContextInstance == null) {
                throw new IllegalArgumentException("Could not find swimlane context instance");
            }
            this.swimlaneContextInstance = swimlaneContextInstance;
        }
        return this.swimlaneContextInstance;
    }

    @Override
    public void triggerCompleted(WorkItem workItem) {
        String newActorId;
        String swimlaneName = this.getHumanTaskNode().getSwimlane();
        SwimlaneContextInstance swimlaneContextInstance = this.getSwimlaneContextInstance(swimlaneName);
        if (swimlaneContextInstance != null && (newActorId = (String)workItem.getResult("ActorId")) != null) {
            swimlaneContextInstance.setActorId(swimlaneName, newActorId);
        }
        super.triggerCompleted(workItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalEvent(String type, Object event) {
        TimerInstance timerInstance;
        if ("timerTriggered".equals(type) && (timerInstance = (TimerInstance)event).getId() == this.suspendUntilTimerId) {
            RuntimeManager runtimeManager = RuntimeManagerRegistry.get().getManager(this.getProcessInstance().getDeploymentId());
            RuntimeEngine engine = runtimeManager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)timerInstance.getProcessInstanceId()));
            try {
                Task task = engine.getTaskService().getTaskByWorkItemId(this.getWorkItemId());
                engine.getTaskService().resume(task.getId().longValue(), ADMINISTRATOR_USER);
            }
            finally {
                runtimeManager.disposeRuntimeEngine(engine);
            }
            this.suspendUntilTimerId = -1L;
            return;
        }
        super.signalEvent(type, event);
        if (!this.ownsWorkItem(event)) {
            return;
        }
        if (SUSPEND_SIGNAL.equals(type)) {
            this.createSuspendTimer((WorkItem)event);
        } else if (ACTIVATE_SIGNAL.equals(type)) {
            this.removeSuspendTimer();
        }
    }

    @Override
    public void cancel(NodeInstance.CancelType cancelType) {
        if (this.suspendUntilTimerId != -1L) {
            this.removeSuspendTimer();
        }
        super.cancel(cancelType);
    }

    private boolean ownsWorkItem(Object event) {
        if (!(event instanceof WorkItem)) {
            return false;
        }
        WorkItem workItem = (WorkItem)event;
        return this.getWorkItemId() == workItem.getId() || this.getWorkItemId() == -1L && this.getWorkItem().getId() == workItem.getId();
    }

    private void removeSuspendTimer() {
        if (this.suspendUntilTimerId == -1L) {
            return;
        }
        ((WorkflowProcessInstanceImpl)this.getProcessInstance()).cancelTimer(this.suspendUntilTimerId);
        this.suspendUntilTimerId = -1L;
    }

    private void createSuspendTimer(WorkItem workItem) {
        String suspendUntil = (String)workItem.getParameter(SUSPEND_UNTIL_PARAMETER);
        if (suspendUntil == null) {
            suspendUntil = (String)this.getNode().getMetaData().get(SUSPEND_UNTIL_PARAMETER);
        }
        if (suspendUntil == null) {
            return;
        }
        this.addTimerListener();
        TimerInstance timer = ((WorkflowProcessInstanceImpl)this.getProcessInstance()).configureTimer(suspendUntil, this.getNodeName() + "SuspendUntil", true);
        if (timer == null) {
            return;
        }
        this.suspendUntilTimerId = timer.getId();
        logger.debug("suspendUntilTimerId for node instance {} with expression {}", (Object)this.getId(), (Object)suspendUntil);
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        this.addHumanTaskListeners();
        if (this.suspendUntilTimerId >= 0L) {
            this.addTimerListener();
        }
    }

    private void addHumanTaskListeners() {
        this.getProcessInstance().addEventListener(ACTIVATE_SIGNAL, this, false);
        this.getProcessInstance().addEventListener(SUSPEND_SIGNAL, this, false);
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        this.removeHumanTaskListeners();
    }

    private void removeHumanTaskListeners() {
        this.getProcessInstance().removeEventListener(ACTIVATE_SIGNAL, this, false);
        this.getProcessInstance().removeEventListener(SUSPEND_SIGNAL, this, false);
    }
}

