/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.services.rest.factories;

import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.ala.runtime.RuntimeId;
import org.guvnor.ala.runtime.RuntimeManager;

public class RuntimeManagerFactory {
    private final Collection<RuntimeManager> managers = new ArrayList<RuntimeManager>();

    public RuntimeManagerFactory() {
    }

    @Inject
    public RuntimeManagerFactory(Instance<RuntimeManager> managers) {
        managers.forEach(this.managers::add);
    }

    public void startRuntime(RuntimeId runtimeId) {
        this.managers.stream().filter(p -> p.supports(runtimeId)).findFirst().get().start(runtimeId);
    }

    public void stopRuntime(RuntimeId runtimeId) {
        this.managers.stream().filter(p -> p.supports(runtimeId)).findFirst().get().stop(runtimeId);
    }

    public void restartRuntime(RuntimeId runtimeId) {
        this.managers.stream().filter(p -> p.supports(runtimeId)).findFirst().get().restart(runtimeId);
    }

    public void refreshRuntime(RuntimeId runtimeId) {
        this.managers.stream().filter(p -> p.supports(runtimeId)).findFirst().get().refresh(runtimeId);
    }
}

