/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.io.IOException;
import java.util.HashSet;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.RawProtobufMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.impl.AbstractMarshallerCodeGenerator;
import org.infinispan.protostream.annotations.impl.GeneratedMarshallerBase;
import org.infinispan.protostream.annotations.impl.ProtoEnumTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoFieldMetadata;
import org.infinispan.protostream.annotations.impl.ProtoMessageTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.types.XTypeFactory;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.EnumMarshallerDelegate;
import org.infinispan.protostream.impl.Log;
import protostream.javassist.CannotCompileException;
import protostream.javassist.ClassPool;
import protostream.javassist.CtClass;
import protostream.javassist.CtField;
import protostream.javassist.CtMethod;
import protostream.javassist.CtNewMethod;
import protostream.javassist.NotFoundException;

final class MarshallerByteCodeGenerator
extends AbstractMarshallerCodeGenerator {
    private static final Log log = Log.LogFactory.getLog(MarshallerByteCodeGenerator.class);
    private static final String MARSHALLER_CLASS_NAME_PREFIX = "___ProtostreamGeneratedMarshaller_";
    private static long nextId = 0L;
    private final ClassPool cp;
    private final CtClass ioExceptionClass;
    private final CtClass enumMarshallerInterface;
    private final CtClass rawProtobufMarshallerInterface;
    private final CtClass generatedMarshallerBaseClass;
    private final CtClass baseMarshallerDelegateClass;
    private final CtClass enumMarshallerDelegateClass;
    private final CtMethod readFromMethod;
    private final CtMethod writeToMethod;
    private final CtMethod decodeMethod;
    private final CtMethod encodeMethod;

    MarshallerByteCodeGenerator(XTypeFactory typeFactory, String protobufSchemaPackage, ClassPool cp) throws NotFoundException {
        super(typeFactory, protobufSchemaPackage);
        this.cp = cp;
        this.ioExceptionClass = cp.getCtClass(IOException.class.getName());
        this.enumMarshallerInterface = cp.getCtClass(EnumMarshaller.class.getName());
        this.rawProtobufMarshallerInterface = cp.getCtClass(RawProtobufMarshaller.class.getName());
        this.generatedMarshallerBaseClass = cp.getCtClass(GeneratedMarshallerBase.class.getName());
        this.baseMarshallerDelegateClass = cp.getCtClass(BaseMarshallerDelegate.class.getName());
        this.enumMarshallerDelegateClass = cp.getCtClass(EnumMarshallerDelegate.class.getName());
        String rawProtobufInputStreamName = RawProtoStreamReader.class.getName().replace('.', '/');
        String rawProtobufOutputStreamName = RawProtoStreamWriter.class.getName().replace('.', '/');
        String serializationContextName = ImmutableSerializationContext.class.getName().replace('.', '/');
        this.readFromMethod = this.rawProtobufMarshallerInterface.getMethod("readFrom", "(L" + serializationContextName + ";L" + rawProtobufInputStreamName + ";)Ljava/lang/Object;");
        this.writeToMethod = this.rawProtobufMarshallerInterface.getMethod("writeTo", "(L" + serializationContextName + ";L" + rawProtobufOutputStreamName + ";Ljava/lang/Object;)V");
        this.decodeMethod = this.enumMarshallerInterface.getMethod("decode", "(I)Ljava/lang/Enum;");
        this.encodeMethod = this.enumMarshallerInterface.getMethod("encode", "(Ljava/lang/Enum;)I");
    }

    private static synchronized long nextMarshallerClassId() {
        return nextId++;
    }

    private static String makeUniqueMarshallerClassName() {
        return MARSHALLER_CLASS_NAME_PREFIX + MarshallerByteCodeGenerator.nextMarshallerClassId();
    }

    @Override
    public void generateMarshaller(SerializationContext serializationContext, ProtoTypeMetadata ptm) throws Exception {
        Class marshallerClass = null;
        if (ptm instanceof ProtoMessageTypeMetadata) {
            marshallerClass = this.generateMessageMarshaller((ProtoMessageTypeMetadata)ptm);
        } else if (ptm instanceof ProtoEnumTypeMetadata) {
            marshallerClass = this.generateEnumMarshaller((ProtoEnumTypeMetadata)ptm);
        }
        if (marshallerClass != null) {
            BaseMarshaller marshaller = marshallerClass.newInstance();
            serializationContext.registerMarshaller(marshaller);
        }
    }

    private Class<EnumMarshaller> generateEnumMarshaller(ProtoEnumTypeMetadata petm) throws NotFoundException, CannotCompileException {
        String marshallerClassName = MarshallerByteCodeGenerator.makeUniqueMarshallerClassName();
        CtClass enumClass = this.cp.get(petm.getJavaClass().getName());
        CtClass marshallerImpl = enumClass.makeNestedClass(marshallerClassName, true);
        if (log.isTraceEnabled()) {
            log.tracef("Generating enum marshaller %s for %s", marshallerImpl.getName(), petm.getJavaClass().getName());
        }
        marshallerImpl.addInterface(this.enumMarshallerInterface);
        marshallerImpl.setModifiers(marshallerImpl.getModifiers() & 0xFFFFFBFF | 0x10);
        marshallerImpl.addMethod(CtNewMethod.make("public final Class getJavaClass() { return " + petm.getJavaClass().getName() + ".class; }", marshallerImpl));
        marshallerImpl.addMethod(CtNewMethod.make("public final String getTypeName() { return \"" + this.makeQualifiedTypeName(petm.getFullName()) + "\"; }", marshallerImpl));
        CtMethod ctDecodeMethod = new CtMethod(this.decodeMethod, marshallerImpl, null);
        ctDecodeMethod.setModifiers(ctDecodeMethod.getModifiers() | 0x10);
        String decodeSrc = this.generateEnumDecodeMethodBody(petm);
        if (log.isTraceEnabled()) {
            log.tracef("%s %s", ctDecodeMethod.getLongName(), decodeSrc);
        }
        ctDecodeMethod.setBody(decodeSrc);
        marshallerImpl.addMethod(ctDecodeMethod);
        CtMethod ctEncodeMethod = new CtMethod(this.encodeMethod, marshallerImpl, null);
        ctEncodeMethod.setModifiers(ctEncodeMethod.getModifiers() | 0x10);
        String encodeSrc = this.generateEnumEncodeMethodBody(petm);
        if (log.isTraceEnabled()) {
            log.tracef("%s %s", ctEncodeMethod.getLongName(), encodeSrc);
        }
        ctEncodeMethod.setBody(encodeSrc);
        marshallerImpl.addMethod(ctEncodeMethod);
        Class<EnumMarshaller> generatedMarshallerClass = marshallerImpl.toClass();
        marshallerImpl.detach();
        return generatedMarshallerClass;
    }

    private Class<RawProtobufMarshaller> generateMessageMarshaller(ProtoMessageTypeMetadata pmtm) throws NotFoundException, CannotCompileException {
        String marshallerClassName = MarshallerByteCodeGenerator.makeUniqueMarshallerClassName();
        CtClass entityClass = this.cp.get(pmtm.getJavaClass().getName());
        CtClass marshallerImpl = entityClass.makeNestedClass(marshallerClassName, true);
        if (log.isTraceEnabled()) {
            log.tracef("Generating message marshaller %s for %s", marshallerImpl.getName(), pmtm.getJavaClass().getName());
        }
        marshallerImpl.addInterface(this.rawProtobufMarshallerInterface);
        marshallerImpl.setSuperclass(this.generatedMarshallerBaseClass);
        marshallerImpl.setModifiers(marshallerImpl.getModifiers() & 0xFFFFFBFF | 0x10);
        this.addMarshallerDelegateFields(marshallerImpl, pmtm);
        marshallerImpl.addMethod(CtNewMethod.make("public final Class getJavaClass() { return " + pmtm.getJavaClass().getName() + ".class; }", marshallerImpl));
        marshallerImpl.addMethod(CtNewMethod.make("public final String getTypeName() { return \"" + this.makeQualifiedTypeName(pmtm.getFullName()) + "\"; }", marshallerImpl));
        CtMethod ctReadFromMethod = new CtMethod(this.readFromMethod, marshallerImpl, null);
        ctReadFromMethod.setExceptionTypes(new CtClass[]{this.ioExceptionClass});
        ctReadFromMethod.setModifiers(ctReadFromMethod.getModifiers() | 0x10);
        String readFromSrc = this.generateReadFromMethodBody(pmtm);
        if (log.isTraceEnabled()) {
            log.tracef("%s %s", ctReadFromMethod.getLongName(), readFromSrc);
        }
        ctReadFromMethod.setBody(readFromSrc);
        marshallerImpl.addMethod(ctReadFromMethod);
        CtMethod ctWriteToMethod = new CtMethod(this.writeToMethod, marshallerImpl, null);
        ctWriteToMethod.setExceptionTypes(new CtClass[]{this.ioExceptionClass});
        ctWriteToMethod.setModifiers(ctWriteToMethod.getModifiers() | 0x10);
        String writeToSrc = this.generateWriteToMethodBody(pmtm);
        if (log.isTraceEnabled()) {
            log.tracef("%s %s", ctWriteToMethod.getLongName(), writeToSrc);
        }
        ctWriteToMethod.setBody(writeToSrc);
        marshallerImpl.addMethod(ctWriteToMethod);
        Class<RawProtobufMarshaller> generatedMarshallerClass = marshallerImpl.toClass();
        marshallerImpl.detach();
        return generatedMarshallerClass;
    }

    private void addMarshallerDelegateFields(CtClass marshallerImpl, ProtoMessageTypeMetadata messageTypeMetadata) throws CannotCompileException {
        HashSet<String> addedFields = new HashSet<String>();
        for (ProtoFieldMetadata fieldMetadata : messageTypeMetadata.getFields().values()) {
            switch (fieldMetadata.getProtobufType()) {
                case GROUP: 
                case MESSAGE: 
                case ENUM: {
                    String fieldName = this.makeMarshallerDelegateFieldName(fieldMetadata);
                    if (!addedFields.add(fieldName)) break;
                    CtField marshallerDelegateField = new CtField(fieldMetadata.getJavaType().isEnum() ? this.enumMarshallerDelegateClass : this.baseMarshallerDelegateClass, fieldName, marshallerImpl);
                    marshallerDelegateField.setModifiers(2);
                    marshallerImpl.addField(marshallerDelegateField);
                }
            }
        }
    }
}

