/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.invocation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.Callable;
import org.mockito.Mockito;
import org.mockito.invocation.Invocation;
import org.mockito.mock.MockCreationSettings;
import org.powermock.api.support.SafeExceptionRethrower;
import org.powermock.core.MockRepository;
import org.powermock.reflect.Whitebox;

class InvocationFactory {
    InvocationFactory() {
    }

    Invocation createInvocation(Object mock, Method method, MockCreationSettings settings, Object ... arguments) {
        Callable realMethod = this.createRealMethod(mock, method, arguments);
        return Mockito.framework().getInvocationFactory().createInvocation(mock, settings, method, realMethod, arguments);
    }

    private Callable createRealMethod(final Object delegator, final Method method, final Object ... arguments) {
        return new Callable(){

            public Object call() throws Exception {
                boolean isFinalSystemClass;
                Class type = Whitebox.getType((Object)delegator);
                boolean bl = isFinalSystemClass = type.getName().startsWith("java.") && Modifier.isFinal(type.getModifiers());
                if (!isFinalSystemClass) {
                    MockRepository.putAdditionalState((String)"DontMockNextCall", (Object)true);
                }
                try {
                    return method.invoke(delegator, arguments);
                }
                catch (InvocationTargetException e) {
                    SafeExceptionRethrower.safeRethrow((Throwable)e.getCause());
                    return null;
                }
            }
        };
    }
}

