/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.driver.impl;

import java.util.HashMap;
import org.kie.api.definition.type.Description;
import org.kie.api.definition.type.Duration;
import org.kie.api.definition.type.Expires;
import org.kie.api.definition.type.Label;
import org.kie.api.definition.type.Position;
import org.kie.api.definition.type.Role;
import org.kie.api.definition.type.Timestamp;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.AnnotationValuePairDefinition;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.driver.AnnotationDriver;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverException;
import org.kie.workbench.common.services.datamodeller.parser.descr.AnnotationDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ElementValueDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ElementValuePairDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ElementValuePairListDescr;
import org.kie.workbench.common.services.datamodeller.util.StringEscapeUtils;

public class DefaultJavaModelAnnotationDriver
implements AnnotationDriver {
    @Override
    public Annotation buildAnnotation(AnnotationDefinition annotationDefinition, Object annotationToken) throws ModelDriverException {
        AnnotationImpl annotation;
        block5: {
            ElementValuePairListDescr valuePairListDescr;
            AnnotationDescr javaAnnotationToken;
            block4: {
                javaAnnotationToken = (AnnotationDescr)annotationToken;
                annotation = new AnnotationImpl(annotationDefinition);
                if (annotationDefinition.isMarker()) {
                    return annotation;
                }
                if (!javaAnnotationToken.hasElementValue()) break block4;
                for (AnnotationValuePairDefinition annotationMember : annotationDefinition.getValuePairs()) {
                    if (!"value".equals(annotationMember.getName())) continue;
                    annotation.setValue(annotationMember.getName(), this.parseParamValue(annotationDefinition, annotationMember.getName(), javaAnnotationToken.getElementValue().getValue()));
                }
                break block5;
            }
            if (!javaAnnotationToken.hasElementValuePairs() || (valuePairListDescr = javaAnnotationToken.getElementValuePairs()) == null || valuePairListDescr.getValuePairs() == null) break block5;
            HashMap<String, ElementValueDescr> valuePairValues = new HashMap<String, ElementValueDescr>();
            for (ElementValuePairDescr valuePair : valuePairListDescr.getValuePairs()) {
                valuePairValues.put(valuePair.getIdentifier().getIdentifier(), valuePair.getValue());
            }
            for (AnnotationValuePairDefinition annotationMember : annotationDefinition.getValuePairs()) {
                ElementValueDescr value = (ElementValueDescr)valuePairValues.get(annotationMember.getName());
                if (value == null) continue;
                annotation.setValue(annotationMember.getName(), this.parseParamValue(annotationDefinition, annotationMember.getName(), value.getValue()));
            }
        }
        return annotation;
    }

    private String parseParamValue(AnnotationDefinition annotationDefinition, String param, String value) {
        String result = value;
        if (result != null && (Description.class.getName().equals(annotationDefinition.getClassName()) || Label.class.getName().equals(annotationDefinition.getClassName()) || Timestamp.class.getName().equals(annotationDefinition.getClassName()) || Duration.class.getName().equals(annotationDefinition.getClassName()) || Expires.class.getName().equals(annotationDefinition.getClassName()))) {
            if (result.startsWith("\"")) {
                String string = result = result.length() > 1 ? result.substring(1, result.length()) : "";
            }
            if (result.endsWith("\"")) {
                result = result.length() > 1 ? result.substring(0, result.length() - 1) : "";
            }
            result = StringEscapeUtils.unescapeJava(result);
        } else if (Position.class.getName().equals(annotationDefinition.getClassName())) {
            result = value;
        } else if (Role.class.getName().equals(annotationDefinition.getClassName())) {
            result = value != null && value.endsWith("FACT") ? "FACT" : (value != null && value.endsWith("EVENT") ? "EVENT" : value);
        }
        return result;
    }
}

