/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.properties.editor.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.InputGroup;
import org.gwtbootstrap3.client.ui.PanelGroup;
import org.gwtbootstrap3.client.ui.TextBox;
import org.uberfire.ext.properties.editor.client.PropertyEditorHelper;
import org.uberfire.ext.properties.editor.model.PropertyEditorEvent;

public class PropertyEditorWidget
extends Composite {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    @UiField
    PanelGroup propertyMenu;
    PropertyEditorEvent originalEvent;
    @UiField
    InputGroup filterGroup;
    @UiField
    TextBox filterBox;
    @UiField
    Button reload;
    List<String> expandedCategories = new ArrayList<String>();

    public PropertyEditorWidget() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    @PostConstruct
    public void init() {
        this.propertyMenu.setId(DOM.createUniqueId());
    }

    public void handle(PropertyEditorEvent event) {
        if (PropertyEditorHelper.validade(event)) {
            this.originalEvent = event;
            this.filterBox.setText("");
            PropertyEditorHelper.extractEditorFrom(this, this.propertyMenu, event);
        }
    }

    @UiHandler(value={"reload"})
    void onReload(ClickEvent e) {
        this.filterBox.setText("");
        PropertyEditorHelper.extractEditorFrom(this, this.propertyMenu, this.originalEvent, "");
    }

    @UiHandler(value={"filterBox"})
    public void onKeyUp(KeyUpEvent e) {
        if (this.originalEvent != null) {
            this.propertyMenu.clear();
            PropertyEditorHelper.extractEditorFrom(this, this.propertyMenu, this.originalEvent, this.filterBox.getText());
        }
    }

    public void setFilterGroupVisible(boolean visible) {
        this.filterGroup.setVisible(visible);
    }

    public PanelGroup getPropertyMenu() {
        return this.propertyMenu;
    }

    public String getLastOpenAccordionGroupTitle() {
        if (this.expandedCategories.isEmpty()) {
            return "";
        }
        return this.expandedCategories.get(this.expandedCategories.size() - 1);
    }

    @Deprecated
    public void setLastOpenAccordionGroupTitle(String categoryToExpand) {
        this.expandedCategories.add(categoryToExpand);
    }

    public void addExpandedCategory(String ... categoriesToExpand) {
        this.expandedCategories.addAll(Arrays.asList(categoriesToExpand));
    }

    public List<String> getExpandedCategories() {
        return this.expandedCategories;
    }

    protected void collapseCategory(String categoryToCollapse) {
        this.expandedCategories.remove(categoryToCollapse);
    }

    static interface MyUiBinder
    extends UiBinder<Widget, PropertyEditorWidget> {
    }
}

