/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.processing.layout;

import java.util.ArrayList;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.HasBounds;
import org.kie.workbench.common.stunner.core.graph.processing.layout.Layout;
import org.kie.workbench.common.stunner.core.graph.processing.layout.LayoutService;

public abstract class AbstractLayoutService
implements LayoutService {
    private static final double CLOSE_TO_ZERO_TOLERANCE = 0.1;

    public boolean hasLayoutInformation(Graph<?, ?> graph) {
        double threshold = this.getLayoutInformationThreshold(graph);
        int nodesWithLayout = 0;
        for (Node n : graph.nodes()) {
            Object content = n.getContent();
            if (content instanceof HasBounds && !AbstractLayoutService.isNullOrCloseToZero(((HasBounds)content).getBounds())) {
                ++nodesWithLayout;
            }
            if (!((double)nodesWithLayout >= threshold)) continue;
            return true;
        }
        return false;
    }

    protected double getLayoutInformationThreshold(Graph<?, ?> graph) {
        ArrayList list = new ArrayList();
        graph.nodes().iterator().forEachRemaining(list::add);
        return (double)list.size() / 4.0;
    }

    private static boolean isNullOrCloseToZero(Bounds bounds) {
        if (bounds == null) {
            return true;
        }
        Bound upperLeft = bounds.getUpperLeft();
        return AbstractLayoutService.isCloseToZero(upperLeft.getX()) && AbstractLayoutService.isCloseToZero(upperLeft.getY());
    }

    protected static boolean isCloseToZero(double value) {
        return Math.abs(value - 0.0) < 0.1;
    }

    public abstract Layout createLayout(Graph<?, ?> var1);
}

