/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.util.Optional;
import java.util.stream.Stream;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;

public class ExpressionsUtils {
    private ExpressionsUtils() {
    }

    public static Optional<Object> getFromPossibleSources(String name, ProcessingDTO processingDTO) {
        return Stream.of(ExpressionsUtils.getFromKiePMMLNameValues(name, processingDTO), ExpressionsUtils.getFromDerivedFields(name, processingDTO), ExpressionsUtils.getFromOutputFields(name, processingDTO)).filter(Optional::isPresent).findFirst().map(Optional::get);
    }

    public static Optional<Object> getFromKiePMMLNameValues(String name, ProcessingDTO processingDTO) {
        return processingDTO.getKiePMMLNameValues().stream().filter(kiePMMLNameValue -> kiePMMLNameValue.getName().equals(name)).findFirst().map(KiePMMLNameValue::getValue);
    }

    public static Optional<Object> getFromDerivedFields(String name, ProcessingDTO processingDTO) {
        return processingDTO.getDerivedFields().stream().filter(derivedField -> derivedField.getName().equals(name)).findFirst().map(derivedField -> derivedField.evaluate(processingDTO));
    }

    public static Optional<Object> getFromOutputFields(String name, ProcessingDTO processingDTO) {
        return processingDTO.getOutputFields().stream().filter(outputField -> outputField.getName().equals(name)).findFirst().map(outputField -> outputField.evaluate(processingDTO));
    }
}

