/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.openshift.storage;

import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.kie.server.controller.openshift.storage.ServerTemplateConverter;
import org.kie.server.services.openshift.impl.storage.cloud.KieServerStateOpenShiftRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftServerTemplateStorage
implements KieServerTemplateStorage {
    private static final Logger logger = LoggerFactory.getLogger(OpenShiftServerTemplateStorage.class);
    private static final String SERVER_TEMPLATE_KEYS_CACHE_KEY = "server.template.keys.cache.key";
    private static final String SERVER_TEMPLATE_CACHE_KEY = "server.template.cache.key";
    private static final long DEFAULT_CACHE_TTL = Long.parseLong(System.getProperty("org.kie.server.controller.template.cache.ttl", "60000"));
    private static OpenShiftServerTemplateStorage instance;
    protected static SimpleInMemoryCache storageCache;
    protected KieServerStateOpenShiftRepository repo;
    protected long cacheTTL = DEFAULT_CACHE_TTL;

    protected OpenShiftServerTemplateStorage() {
        this(new KieServerStateOpenShiftRepository());
        logger.info("ServerTemplate cache TTL: {} milliseconds", (Object)this.cacheTTL);
    }

    protected OpenShiftServerTemplateStorage(KieServerStateOpenShiftRepository repo) {
        this.repo = repo;
    }

    public static synchronized OpenShiftServerTemplateStorage getInstance() {
        if (instance == null) {
            instance = new OpenShiftServerTemplateStorage();
        }
        return instance;
    }

    public ServerTemplate store(ServerTemplate serverTemplate) {
        if (this.exists(serverTemplate.getId())) {
            throw new IllegalArgumentException("Server template with id " + serverTemplate.getId() + " is already stored");
        }
        this.repo.create(ServerTemplateConverter.toState(serverTemplate));
        storageCache.clear();
        return ServerTemplateConverter.fromState(this.repo.load(serverTemplate.getId()));
    }

    public List<ServerTemplateKey> loadKeys() {
        List result = (List)storageCache.get(SERVER_TEMPLATE_KEYS_CACHE_KEY);
        if (result == null) {
            result = this.repo.retrieveAllKieServerIds().stream().map(id -> new ServerTemplateKey(id, id)).collect(Collectors.toList());
            storageCache.add(SERVER_TEMPLATE_KEYS_CACHE_KEY, result, this.cacheTTL);
        }
        return result;
    }

    public List<ServerTemplate> load() {
        List result = (List)storageCache.get(SERVER_TEMPLATE_CACHE_KEY);
        if (result == null) {
            result = this.repo.retrieveAllKieServerStates().stream().map(ServerTemplateConverter::fromState).collect(Collectors.toList());
            storageCache.add(SERVER_TEMPLATE_CACHE_KEY, result, this.cacheTTL);
        }
        return result;
    }

    public ServerTemplate load(String identifier) {
        ServerTemplate template = null;
        try {
            template = ServerTemplateConverter.fromState(this.repo.load(identifier));
        }
        catch (Exception e) {
            logger.error("Load server template failed.", (Throwable)e);
        }
        return template;
    }

    public boolean exists(String identifier) {
        return this.repo.exists(identifier);
    }

    public ServerTemplate update(ServerTemplate serverTemplate) {
        this.repo.store(serverTemplate.getId(), ServerTemplateConverter.toState(serverTemplate));
        storageCache.clear();
        return ServerTemplateConverter.fromState(this.repo.load(serverTemplate.getId()));
    }

    public ServerTemplate delete(String identifier) {
        storageCache.clear();
        return ServerTemplateConverter.fromState(this.repo.delete(identifier));
    }

    static {
        storageCache = new SimpleInMemoryCache();
    }

    public static class SimpleInMemoryCache
    implements Cache {
        private final ConcurrentHashMap<String, SoftReference<Object>> cache = new ConcurrentHashMap();
        private final DelayQueue<CacheObject> evictQueue = new DelayQueue();

        public SimpleInMemoryCache() {
            Thread evictor = new Thread(() -> {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        CacheObject cacheEntry = (CacheObject)this.evictQueue.take();
                        this.cache.remove(cacheEntry.getKey(), cacheEntry.getReference());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            });
            evictor.setDaemon(true);
            evictor.start();
        }

        @Override
        public void add(String key, Object value, long periodInMillis) {
            if (key == null) {
                return;
            }
            if (value == null) {
                this.cache.remove(key);
            } else {
                long expiryTime = System.currentTimeMillis() + periodInMillis;
                SoftReference<Object> reference = new SoftReference<Object>(value);
                this.cache.put(key, reference);
                this.evictQueue.put(new CacheObject(key, reference, expiryTime));
            }
        }

        @Override
        public void remove(String key) {
            this.cache.remove(key);
        }

        @Override
        public Object get(String key) {
            return Optional.ofNullable(this.cache.get(key)).map(SoftReference::get).orElse(null);
        }

        @Override
        public void clear() {
            this.cache.clear();
        }

        @Override
        public long size() {
            return this.cache.size();
        }

        private static class CacheObject
        implements Delayed {
            private final String key;
            private final SoftReference<Object> reference;
            private final long expiryTime;

            public CacheObject(String key, SoftReference<Object> reference, long expiryTime) {
                this.key = key;
                this.reference = reference;
                this.expiryTime = expiryTime;
            }

            public String getKey() {
                return this.key;
            }

            public SoftReference<Object> getReference() {
                return this.reference;
            }

            @Override
            public long getDelay(TimeUnit unit) {
                return unit.convert(this.expiryTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }

            @Override
            public int compareTo(Delayed o) {
                return Long.compare(this.expiryTime, ((CacheObject)o).expiryTime);
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof CacheObject)) {
                    return false;
                }
                CacheObject cacheObj = (CacheObject)obj;
                return Objects.equals(cacheObj.key, this.key);
            }

            public int hashCode() {
                return Objects.hashCode(this.key);
            }
        }
    }

    public static interface Cache {
        public void add(String var1, Object var2, long var3);

        public void remove(String var1);

        public Object get(String var1);

        public void clear();

        public long size();
    }
}

