/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.data;

public class Pair<K1, K2> {
    private final PairEqualsMode equalsMode;
    private final K1 k1;
    private final K2 k2;

    public Pair(K1 k1, K2 k2) {
        this.k1 = k1;
        this.k2 = k2;
        this.equalsMode = PairEqualsMode.BOTH;
    }

    public Pair(K1 k1, K2 k2, PairEqualsMode equalsMode) {
        this.k1 = k1;
        this.k2 = k2;
        this.equalsMode = equalsMode;
    }

    public static <K1, K2> Pair<K1, K2> newPair(K1 k1, K2 k2) {
        return new Pair<K1, K2>(k1, k2, PairEqualsMode.BOTH);
    }

    public static <K1, K2> Pair<K1, K2> newPair(K1 k1, K2 k2, PairEqualsMode equalsMode) {
        return new Pair<K1, K2>(k1, k2, equalsMode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        if ((PairEqualsMode.BOTH.equals((Object)this.equalsMode) || PairEqualsMode.K1.equals((Object)this.equalsMode)) && (this.k1 != null ? !this.k1.equals(pair.k1) : pair.k1 != null)) {
            return false;
        }
        return !PairEqualsMode.BOTH.equals((Object)this.equalsMode) && !PairEqualsMode.K2.equals((Object)this.equalsMode) || !(this.k2 != null ? !this.k2.equals(pair.k2) : pair.k2 != null);
    }

    public K1 getK1() {
        return this.k1;
    }

    public K2 getK2() {
        return this.k2;
    }

    public int hashCode() {
        int result = 0;
        if (PairEqualsMode.BOTH.equals((Object)this.equalsMode) || PairEqualsMode.K1.equals((Object)this.equalsMode)) {
            int n = result = this.k1 != null ? this.k1.hashCode() : 0;
        }
        if (PairEqualsMode.BOTH.equals((Object)this.equalsMode) || PairEqualsMode.K2.equals((Object)this.equalsMode)) {
            result = 31 * result + (this.k2 != null ? this.k2.hashCode() : 0);
        }
        return result;
    }

    public static enum PairEqualsMode {
        BOTH,
        K1,
        K2;

    }
}

