/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.io;

import org.junit.Test;
import org.kie.commons.io.CommonIOServiceDotFileTest;
import org.kie.commons.java.nio.file.CopyOption;
import org.kie.commons.java.nio.file.DirectoryNotEmptyException;
import org.kie.commons.java.nio.file.FileAlreadyExistsException;
import org.kie.commons.java.nio.file.NoSuchFileException;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;

public abstract class CommonIOExceptionsServiceDotFileTest
extends CommonIOServiceDotFileTest {
    @Test(expected=NoSuchFileException.class)
    public void deleteNoSuchFileException() {
        Path path = this.getFilePath();
        this.ioService().deleteIfExists(path);
        this.ioService().delete(path);
    }

    @Test(expected=DirectoryNotEmptyException.class)
    public void deleteDirectoryNotEmptyException() {
        Path path = this.getDirectoryPath().resolveSibling("dirToBug");
        this.ioService().createDirectories(path, new FileAttribute[0]);
        this.ioService().write(path.resolve("myFile.txt"), "ooooo!", new OpenOption[0]);
        this.ioService().delete(path);
    }

    @Test(expected=DirectoryNotEmptyException.class)
    public void deleteIfExistsDirectoryNotEmptyException() {
        Path path = this.getDirectoryPath().resolveSibling("dirToBugIfExists");
        this.ioService().createDirectories(path, new FileAttribute[0]);
        this.ioService().write(path.resolve("myFile.txt"), "ooooo!", new OpenOption[0]);
        this.ioService().deleteIfExists(path);
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void newByteChannelFileAlreadyExistsException() {
        Path path = this.getFilePath().resolveSibling("alreadyExists.txt");
        this.ioService().deleteIfExists(path);
        this.ioService().write(path, "ooooo!", new OpenOption[0]);
        this.ioService().newByteChannel(path, new OpenOption[0]);
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void createDirectoryFileAlreadyExistsException() {
        Path path = this.getDirectoryPath().resolveSibling("otherDir");
        this.ioService().deleteIfExists(path);
        this.ioService().createDirectory(path, new FileAttribute[0]);
        this.ioService().createDirectory(path, new FileAttribute[0]);
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void createDirectoriesFileAlreadyExistsException() {
        Path path = this.getDirectoryPath().resolveSibling("otherDir").resolve("innerDir");
        this.ioService().deleteIfExists(path);
        this.ioService().createDirectories(path, new FileAttribute[0]);
        this.ioService().createDirectories(path, new FileAttribute[0]);
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void copyFileAlreadyExistsException() {
        Path path = this.getDirectoryPath().resolveSibling("alreadyExistsTest");
        this.ioService().deleteIfExists(path);
        this.ioService().createDirectories(path, new FileAttribute[0]);
        this.ioService().write(path.resolve("myFile.txt"), "ooooo!", new OpenOption[0]);
        this.ioService().write(path.resolve("mytarget"), "xooooo!", new OpenOption[0]);
        this.ioService().copy(path.resolve("myFile.txt"), path.resolve("mytarget"), new CopyOption[0]);
    }

    @Test(expected=NoSuchFileException.class)
    public void readAttributesNoSuchFileException() {
        Path path = this.getDirectoryPath().resolveSibling("somethingXXX");
        this.ioService().deleteIfExists(path);
        this.ioService().readAttributes(path);
    }
}

