/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.validation;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.kie.commons.validation.PortablePreconditions;

public class PreconditionsTest {
    @Test
    public void shouldDoNotThrowExceptionWhenGettingNotEmptyArray() {
        PortablePreconditions.checkNotEmpty((String)"notEmpty", (Object[])new Object[]{1, 2, 3});
    }

    @Test
    public void shouldDoNotThrowExceptionWhenGettingNotEmptyParameter() {
        PortablePreconditions.checkNotEmpty((String)"notEmpty", (String)"notEmpty");
    }

    @Test
    public void shouldDoNotThrowExceptionWhenGettingNotNullParameter() {
        PortablePreconditions.checkNotNull((String)"notNullable", (Object)"notNullValue");
    }

    @Test
    public void shouldDoNotThrowExceptionWhenGettingNullParameter() {
        PortablePreconditions.checkNullMandatory((String)"nullable", null);
    }

    @Test
    public void shouldDoNotThrowExceptionWhenGettingValidConditionParameter() {
        PortablePreconditions.checkCondition((String)"valid", (boolean)true);
    }

    @Test
    public void shouldDoNotThrowExceptionWhenGettinOnlyNonNullParameters() {
        PortablePreconditions.checkEachParameterNotNull((String)"notNullable", (Object[])new String[]{"nonNull"});
        PortablePreconditions.checkEachParameterNotNull((String)"notNullable", (Object[])new String[]{"nonNull", "anotherNonNull"});
    }

    @Test
    public void shouldGetCorrectErrorNessage() {
        try {
            PortablePreconditions.checkNotNull((String)"notNullable", null);
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Is.is((Object)"Parameter named 'notNullable' should be not null!"));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnCheckEmptyWhenGettingNullParameter() {
        PortablePreconditions.checkNotEmpty((String)"notEmpty", (String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettinAllNullParameter() {
        PortablePreconditions.checkEachParameterNotNull((String)"notNullable", (Object[])new Object[]{null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettingEmptyArray() {
        PortablePreconditions.checkNotEmpty((String)"empty", (Object[])new Object[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettingEmptyParameter() {
        PortablePreconditions.checkNotEmpty((String)"notEmpty", (String)"");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowExceptionWhenGettingInvalidConditionParameter() {
        PortablePreconditions.checkCondition((String)"valid", (boolean)false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettingNonNullParameter() {
        PortablePreconditions.checkNullMandatory((String)"nullable", (Object)"non null");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettingNullArray() {
        PortablePreconditions.checkNotEmpty((String)"empty", (Object[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettingNullParameter() {
        PortablePreconditions.checkNotNull((String)"notNullable", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettingSpacedParameter() {
        PortablePreconditions.checkNotEmpty((String)"notEmpty", (String)"    ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenGettinOneNullParameter() {
        PortablePreconditions.checkEachParameterNotNull((String)"notNullable", (Object[])new String[]{"nonNull", null});
    }
}

