/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.fs.jgit;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.fest.assertions.api.Assertions;
import org.junit.Test;
import org.kie.commons.java.nio.file.FileSystem;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.kie.commons.java.nio.fs.jgit.JGitFileSystem;
import org.kie.commons.java.nio.fs.jgit.JGitFileSystemProvider;
import org.kie.commons.java.nio.fs.jgit.JGitPathImpl;

public class JGitFileSystemProviderUnsupportedOpTest {
    private static final JGitFileSystemProvider PROVIDER = new JGitFileSystemProvider();
    private static final Map<String, Object> EMPTY_ENV = Collections.emptyMap();

    @Test
    public void testNewFileSystemUnsupportedOp() {
        URI newRepo = URI.create("git://someunsup-repo-name");
        FileSystem fs = PROVIDER.newFileSystem(newRepo, EMPTY_ENV);
        JGitPathImpl path = JGitPathImpl.create((JGitFileSystem)((JGitFileSystem)fs), (String)"", (String)"repo2-name", (boolean)false);
        try {
            PROVIDER.newFileSystem((Path)path, EMPTY_ENV);
            Assertions.failBecauseExceptionWasNotThrown(UnsupportedOperationException.class);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testNewFileChannelUnsupportedOp() {
        URI newRepo = URI.create("git://newfcrepo-name");
        PROVIDER.newFileSystem(newRepo, EMPTY_ENV);
        Path path = PROVIDER.getPath(URI.create("git://newfcrepo-name/file.txt"));
        Set options = Collections.emptySet();
        try {
            PROVIDER.newFileChannel(path, options, new FileAttribute[0]);
            Assertions.failBecauseExceptionWasNotThrown(UnsupportedOperationException.class);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testNewAsynchronousFileChannelUnsupportedOp() {
        URI newRepo = URI.create("git://newasyncrepo-name");
        PROVIDER.newFileSystem(newRepo, EMPTY_ENV);
        Path path = PROVIDER.getPath(URI.create("git://newasyncrepo-name/file.txt"));
        Set options = Collections.emptySet();
        try {
            PROVIDER.newAsynchronousFileChannel(path, options, null, new FileAttribute[0]);
            Assertions.failBecauseExceptionWasNotThrown(UnsupportedOperationException.class);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testNewByteChannelUnsupportedOp() {
        URI newRepo = URI.create("git://newbytechannelrepo-name");
        PROVIDER.newFileSystem(newRepo, EMPTY_ENV);
        Path path = PROVIDER.getPath(URI.create("git://newbytechannelrepo-name/file.txt"));
        Set options = Collections.emptySet();
        try {
            PROVIDER.newByteChannel(path, options, new FileAttribute[0]);
            Assertions.failBecauseExceptionWasNotThrown(UnsupportedOperationException.class);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testCreateSymbolicLinkUnsupportedOp() {
        URI newRepo = URI.create("git://symbolic-repo-name");
        PROVIDER.newFileSystem(newRepo, EMPTY_ENV);
        Path link = PROVIDER.getPath(URI.create("git://symbolic-repo-name/link.lnk"));
        Path path = PROVIDER.getPath(URI.create("git://symbolic-repo-name/file.txt"));
        try {
            PROVIDER.createSymbolicLink(link, path, new FileAttribute[0]);
            Assertions.failBecauseExceptionWasNotThrown(UnsupportedOperationException.class);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testCreateLinkUnsupportedOp() {
        URI newRepo = URI.create("git://link-repo-name");
        PROVIDER.newFileSystem(newRepo, EMPTY_ENV);
        Path link = PROVIDER.getPath(URI.create("git://link-repo-name/link.lnk"));
        Path path = PROVIDER.getPath(URI.create("git://link-repo-name/file.txt"));
        try {
            PROVIDER.createLink(link, path);
            Assertions.failBecauseExceptionWasNotThrown(UnsupportedOperationException.class);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testReadSymbolicLinkUnsupportedOp() {
        URI newRepo = URI.create("git://read-link-repo-name");
        PROVIDER.newFileSystem(newRepo, EMPTY_ENV);
        Path link = PROVIDER.getPath(URI.create("git://read-link-repo-name/link.lnk"));
        try {
            PROVIDER.readSymbolicLink(link);
            Assertions.failBecauseExceptionWasNotThrown(UnsupportedOperationException.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

