/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.fs.jgit;

import org.eclipse.jgit.lib.Repository;
import org.kie.commons.java.nio.IOException;
import org.kie.commons.java.nio.file.FileStore;
import org.kie.commons.java.nio.file.attribute.BasicFileAttributeView;
import org.kie.commons.java.nio.file.attribute.FileAttributeView;
import org.kie.commons.java.nio.file.attribute.FileStoreAttributeView;
import org.kie.commons.validation.PortablePreconditions;

public class JGitFileStore
implements FileStore {
    private final Repository repository;

    JGitFileStore(Repository repository) {
        this.repository = (Repository)PortablePreconditions.checkNotNull((String)"repository", (Object)repository);
    }

    public String name() {
        return this.repository.getDirectory().getName();
    }

    public String type() {
        return "file";
    }

    public boolean isReadOnly() {
        return false;
    }

    public long getTotalSpace() throws IOException {
        return this.repository.getDirectory().getTotalSpace();
    }

    public long getUsableSpace() throws IOException {
        return this.repository.getDirectory().getUsableSpace();
    }

    public long getUnallocatedSpace() throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        PortablePreconditions.checkNotNull((String)"type", type);
        return type.equals(BasicFileAttributeView.class);
    }

    public boolean supportsFileAttributeView(String name) {
        PortablePreconditions.checkNotEmpty((String)"name", (String)name);
        return name.equals("basic");
    }

    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> type) {
        PortablePreconditions.checkNotNull((String)"type", type);
        return null;
    }

    public Object getAttribute(String attribute) throws UnsupportedOperationException, IOException {
        PortablePreconditions.checkNotEmpty((String)"attribute", (String)attribute);
        if (attribute.equals("totalSpace")) {
            return this.getTotalSpace();
        }
        if (attribute.equals("usableSpace")) {
            return this.getUsableSpace();
        }
        if (attribute.equals("readOnly")) {
            return this.isReadOnly();
        }
        if (attribute.equals("name")) {
            return this.name();
        }
        throw new UnsupportedOperationException("Attribute '" + attribute + "' not available");
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof FileStore)) {
            return false;
        }
        FileStore ofs = (FileStore)o;
        return this.name().equals(ofs.name());
    }

    public int hashCode() {
        return this.name().hashCode();
    }
}

