/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.fs.jgit;

import java.io.OutputStream;
import java.net.URI;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IterableAssert;
import org.junit.Test;
import org.kie.commons.java.nio.IOException;
import org.kie.commons.java.nio.file.CopyOption;
import org.kie.commons.java.nio.file.DirectoryNotEmptyException;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.FileAlreadyExistsException;
import org.kie.commons.java.nio.file.NoSuchFileException;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.fs.jgit.AbstractTestInfra;
import org.kie.commons.java.nio.fs.jgit.JGitFileSystemProvider;

public class JGitFileSystemProviderCpMvTest
extends AbstractTestInfra {
    private static final JGitFileSystemProvider PROVIDER = JGitFileSystemProvider.getInstance();

    @Test
    public void testCopyBranches() throws java.io.IOException {
        URI newRepo = URI.create("git://copybranch-test-repo");
        PROVIDER.newFileSystem(newRepo, EMPTY_ENV);
        Path path = PROVIDER.getPath(URI.create("git://master@copybranch-test-repo/myfile1.txt"));
        OutputStream outStream = PROVIDER.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = PROVIDER.getPath(URI.create("git://user_branch@copybranch-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = PROVIDER.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = PROVIDER.getPath(URI.create("git://user_branch@copybranch-test-repo/myfile3.txt"));
        OutputStream outStream3 = PROVIDER.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        Path source = PROVIDER.getPath(URI.create("git://user_branch@copybranch-test-repo"));
        Path target = PROVIDER.getPath(URI.create("git://other_branch@copybranch-test-repo"));
        PROVIDER.copy(source, target, new CopyOption[0]);
        DirectoryStream stream = PROVIDER.newDirectoryStream(PROVIDER.getPath(URI.create("git://other_branch@copybranch-test-repo/")), null);
        ((IterableAssert)Assertions.assertThat((Iterable)stream).isNotNull()).hasSize(2);
        try {
            PROVIDER.copy(source, target, new CopyOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(FileAlreadyExistsException.class);
        }
        catch (FileAlreadyExistsException e) {
            // empty catch block
        }
        Path notExists = PROVIDER.getPath(URI.create("git://xxx_user_branch@copybranch-test-repo"));
        Path notExists2 = PROVIDER.getPath(URI.create("git://xxx_other_branch@copybranch-test-repo"));
        try {
            PROVIDER.copy(notExists, notExists2, new CopyOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(NoSuchFileException.class);
        }
        catch (NoSuchFileException e) {
            // empty catch block
        }
    }

    @Test
    public void testCopyFiles() throws java.io.IOException {
        URI newRepo = URI.create("git://copyasset-test-repo");
        PROVIDER.newFileSystem(newRepo, EMPTY_ENV);
        Path path = PROVIDER.getPath(URI.create("git://master@copyasset-test-repo/myfile1.txt"));
        OutputStream outStream = PROVIDER.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = PROVIDER.getPath(URI.create("git://user_branch@copyasset-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = PROVIDER.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = PROVIDER.getPath(URI.create("git://user_branch@copyasset-test-repo/myfile3.txt"));
        OutputStream outStream3 = PROVIDER.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        Path target = PROVIDER.getPath(URI.create("git://user_branch@copyasset-test-repo/myfile1.txt"));
        PROVIDER.copy(path, target, new CopyOption[0]);
        DirectoryStream stream = PROVIDER.newDirectoryStream(PROVIDER.getPath(URI.create("git://user_branch@copyasset-test-repo/")), null);
        ((IterableAssert)Assertions.assertThat((Iterable)stream).isNotNull()).hasSize(3);
    }

    @Test
    public void testCopyDir() throws java.io.IOException {
        URI newRepo = URI.create("git://copydir-test-repo");
        PROVIDER.newFileSystem(newRepo, EMPTY_ENV);
        Path path = PROVIDER.getPath(URI.create("git://master@copydir-test-repo/myfile1.txt"));
        OutputStream outStream = PROVIDER.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = PROVIDER.getPath(URI.create("git://user_branch@copydir-test-repo/path/myfile2.txt"));
        OutputStream outStream2 = PROVIDER.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = PROVIDER.getPath(URI.create("git://user_branch@copydir-test-repo/path/myfile3.txt"));
        OutputStream outStream3 = PROVIDER.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        Path source = PROVIDER.getPath(URI.create("git://user_branch@copydir-test-repo/path"));
        Path target = PROVIDER.getPath(URI.create("git://master@copydir-test-repo/"));
        PROVIDER.copy(source, target, new CopyOption[0]);
        DirectoryStream stream = PROVIDER.newDirectoryStream(target, null);
        ((IterableAssert)Assertions.assertThat((Iterable)stream).isNotNull()).hasSize(3);
        source = PROVIDER.getPath(URI.create("git://user_branch@copydir-test-repo/path"));
        target = PROVIDER.getPath(URI.create("git://master@copydir-test-repo/some/place/here/"));
        PROVIDER.copy(source, target, new CopyOption[0]);
        stream = PROVIDER.newDirectoryStream(target, null);
        ((IterableAssert)Assertions.assertThat((Iterable)stream).isNotNull()).hasSize(2);
        source = PROVIDER.getPath(URI.create("git://user_branch@copydir-test-repo/path"));
        target = PROVIDER.getPath(URI.create("git://master@copydir-test-repo/soXme/place/here"));
        PROVIDER.copy(source, target, new CopyOption[0]);
        stream = PROVIDER.newDirectoryStream(target, null);
        ((IterableAssert)Assertions.assertThat((Iterable)stream).isNotNull()).hasSize(2);
        source = PROVIDER.getPath(URI.create("git://user_branch@copydir-test-repo/"));
        target = PROVIDER.getPath(URI.create("git://master@copydir-test-repo/other_here/"));
        PROVIDER.copy(source, target, new CopyOption[0]);
        stream = PROVIDER.newDirectoryStream(target, null);
        ((IterableAssert)Assertions.assertThat((Iterable)stream).isNotNull()).hasSize(1);
        source = PROVIDER.getPath(URI.create("git://user_branch@copydir-test-repo/not_exists"));
        target = PROVIDER.getPath(URI.create("git://master@copydir-test-repo/xxxxxxxxother_here/"));
        try {
            PROVIDER.copy(source, target, new CopyOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(NoSuchFileException.class);
        }
        catch (NoSuchFileException e) {
            // empty catch block
        }
        source = PROVIDER.getPath(URI.create("git://user_branch@copydir-test-repo/"));
        target = PROVIDER.getPath(URI.create("git://master@copydir-test-repo/other_here/"));
        try {
            PROVIDER.copy(source, target, new CopyOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(FileAlreadyExistsException.class);
        }
        catch (FileAlreadyExistsException e) {
            // empty catch block
        }
    }

    @Test
    public void testMoveBranches() throws java.io.IOException {
        URI newRepo = URI.create("git://movebranch-test-repo");
        PROVIDER.newFileSystem(newRepo, EMPTY_ENV);
        Path path = PROVIDER.getPath(URI.create("git://master@movebranch-test-repo/myfile1.txt"));
        OutputStream outStream = PROVIDER.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = PROVIDER.getPath(URI.create("git://user_branch@movebranch-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = PROVIDER.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = PROVIDER.getPath(URI.create("git://user_branch@movebranch-test-repo/myfile3.txt"));
        OutputStream outStream3 = PROVIDER.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        Path source = PROVIDER.getPath(URI.create("git://user_branch@movebranch-test-repo/"));
        Path target = PROVIDER.getPath(URI.create("git://master@movebranch-test-repo/"));
        try {
            PROVIDER.move(source, target, new CopyOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(FileAlreadyExistsException.class);
        }
        catch (IOException e) {
            // empty catch block
        }
        Path source2 = PROVIDER.getPath(URI.create("git://user_branch@movebranch-test-repo/"));
        Path target2 = PROVIDER.getPath(URI.create("git://xxxxddddkh@movebranch-test-repo/"));
        try {
            PROVIDER.move(source2, target2, new CopyOption[0]);
        }
        catch (Exception e) {
            Assertions.fail((String)"should not throw");
        }
    }

    @Test
    public void testMoveFiles() throws java.io.IOException {
        URI newRepo = URI.create("git://moveasset-test-repo");
        PROVIDER.newFileSystem(newRepo, EMPTY_ENV);
        Path path = PROVIDER.getPath(URI.create("git://master@moveasset-test-repo/myfile1.txt"));
        OutputStream outStream = PROVIDER.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = PROVIDER.getPath(URI.create("git://user_branch@moveasset-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = PROVIDER.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = PROVIDER.getPath(URI.create("git://user_branch@moveasset-test-repo/myfile3.txt"));
        OutputStream outStream3 = PROVIDER.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        Path target = PROVIDER.getPath(URI.create("git://user_branch@moveasset-test-repo/myfile1.txt"));
        try {
            PROVIDER.move(path, target, new CopyOption[0]);
        }
        catch (Exception e) {
            Assertions.fail((String)"should move file");
        }
    }

    @Test
    public void testMoveDir() throws java.io.IOException {
        URI newRepo = URI.create("git://movedir-test-repo");
        PROVIDER.newFileSystem(newRepo, EMPTY_ENV);
        Path path = PROVIDER.getPath(URI.create("git://master@movedir-test-repo/myfile1.txt"));
        OutputStream outStream = PROVIDER.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = PROVIDER.getPath(URI.create("git://user_branch@movedir-test-repo/path/myfile2.txt"));
        OutputStream outStream2 = PROVIDER.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = PROVIDER.getPath(URI.create("git://user_branch@movedir-test-repo/path/myfile3.txt"));
        OutputStream outStream3 = PROVIDER.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        Path source = PROVIDER.getPath(URI.create("git://user_branch@movedir-test-repo/path"));
        Path target = PROVIDER.getPath(URI.create("git://master@movedir-test-repo/"));
        try {
            PROVIDER.move(source, target, new CopyOption[0]);
        }
        catch (IOException e) {
            Assertions.assertThat((Throwable)e.getCause()).isInstanceOf(DirectoryNotEmptyException.class);
        }
    }
}

