/*
 * Copyright 2012 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.kieora.engine;

import org.kie.kieora.model.KObject;
import org.kie.kieora.model.KObjectKey;

public interface MetaIndexEngine {

    public static final String FULL_TEXT_FIELD = "fullText";

    boolean freshIndex();

    void startBatchMode();

    void index( final KObject object );

    void index( final KObject... objects );

    void rename( final KObjectKey from,
                 final KObjectKey to );

    void delete( final KObjectKey objectKey );

    void delete( final KObjectKey... objectsKey );

    void commit();

    void dispose();
}
