/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.model;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.efesto.common.api.model.FRI;

class FRITest {
    private static final String basePath = "base/Path";
    private static final String model = "model";

    FRITest() {
    }

    @Test
    void getBasePath() {
        FRI retrieved = new FRI(basePath, model);
        Assertions.assertThat((String)retrieved.getBasePath()).isEqualTo("/base/Path");
    }

    @Test
    void getModel() {
        FRI retrieved = new FRI(basePath, model);
        Assertions.assertThat((String)retrieved.getModel()).isEqualTo(model);
    }

    @Test
    void getFri() {
        FRI retrieved = new FRI(basePath, model);
        String expected = "/model/base/Path";
        Assertions.assertThat((String)retrieved.getFri()).isEqualTo(expected);
    }

    @Test
    void generateBasePath() {
        String expected = "/base/Path";
        String retrieved = FRI.generateBasePath((String)basePath, (String)model);
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
        retrieved = FRI.generateBasePath((String)"/base/Path", (String)model);
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
        retrieved = FRI.generateBasePath((String)"/model/base/Path", (String)model);
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
    }

    @Test
    void generateFri() {
        String expected = "/model/base/Path";
        String retrieved = FRI.generateFri((String)basePath, (String)model);
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
        retrieved = FRI.generateFri((String)"/base/Path", (String)model);
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
        retrieved = FRI.generateFri((String)"/model/base/Path", (String)model);
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
        expected = "/model/base/Path/notmodel";
        retrieved = FRI.generateFri((String)"base/Path/notmodel", (String)model);
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
    }
}

