/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.model;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.efesto.common.api.model.FRI;
import org.kie.efesto.common.api.model.GeneratedClassResource;
import org.kie.efesto.common.api.model.GeneratedExecutableResource;
import org.kie.efesto.common.api.model.GeneratedResources;

class GeneratedResourcesTest {
    GeneratedResourcesTest() {
    }

    @Test
    void add() {
        String fullClassName = "full.class.Path";
        GeneratedClassResource generatedClassResource = new GeneratedClassResource(fullClassName);
        String model = "foo";
        FRI fri = new FRI("this/is/fri", model);
        GeneratedExecutableResource generatedFinalResource = new GeneratedExecutableResource(fri, Collections.singletonList(fullClassName));
        GeneratedResources generatedResources = new GeneratedResources();
        generatedResources.add((Object)generatedClassResource);
        generatedResources.add((Object)generatedFinalResource);
        Assertions.assertThat((Iterable)generatedResources).hasSize(2);
        generatedResources = new GeneratedResources();
        generatedResources.add((Object)new GeneratedExecutableResource(fri, Collections.singletonList(fullClassName)));
        generatedResources.add((Object)new GeneratedExecutableResource(fri, Collections.singletonList(fullClassName)));
        Assertions.assertThat((Iterable)generatedResources).hasSize(1);
        generatedResources = new GeneratedResources();
        generatedResources.add((Object)new GeneratedExecutableResource(fri, Collections.singletonList(fullClassName)));
        generatedResources.add((Object)new GeneratedExecutableResource(fri, Collections.singletonList(fullClassName)));
        Assertions.assertThat((Iterable)generatedResources).hasSize(1);
        generatedResources = new GeneratedResources();
        generatedResources.add((Object)new GeneratedExecutableResource(fri, Collections.singletonList(fullClassName)));
        generatedResources.add((Object)new GeneratedExecutableResource(new FRI("different-fri", model), Collections.singletonList(fullClassName)));
        Assertions.assertThat((Iterable)generatedResources).hasSize(2);
        generatedClassResource = new GeneratedClassResource(fullClassName);
        generatedFinalResource = new GeneratedExecutableResource(fri, Collections.singletonList(fullClassName));
        generatedResources = new GeneratedResources();
        generatedResources.add((Object)generatedClassResource);
        generatedResources.add((Object)generatedFinalResource);
        Assertions.assertThat((Iterable)generatedResources).hasSize(2);
        Assertions.assertThat((boolean)generatedResources.contains((Object)generatedClassResource)).isTrue();
        Assertions.assertThat((boolean)generatedResources.contains((Object)generatedFinalResource)).isTrue();
    }
}

