/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.utils;

import java.io.File;
import java.io.InputStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.efesto.common.api.exceptions.KieEfestoCommonException;
import org.kie.efesto.common.api.utils.FileUtils;

class FileUtilsTest {
    private static final String TEST_FILE = "TestingEmptyFile.txt";
    private static final String NOT_EXISTING_FILE = "NotExistingFile.txt";

    FileUtilsTest() {
    }

    @Test
    void getInputStreamFromFileNameExisting() {
        InputStream retrieved = FileUtils.getInputStreamFromFileName((String)TEST_FILE);
        Assertions.assertThat((InputStream)retrieved).isNotNull();
    }

    @Test
    void getInputStreamFromFileNameNotExisting() {
        try {
            FileUtils.getInputStreamFromFileName((String)NOT_EXISTING_FILE);
            Assertions.fail((String)"Expecting KieEfestoCommonException thrown");
        }
        catch (Exception e) {
            Assertions.assertThat((boolean)(e instanceof KieEfestoCommonException)).isTrue();
        }
    }

    @Test
    void getFileFromFileNameExisting() {
        File retrieved = FileUtils.getFileFromFileName((String)TEST_FILE);
        Assertions.assertThat((File)retrieved).isNotNull();
    }

    @Test
    void getFileFromFileNameNotExisting() {
        try {
            FileUtils.getFileFromFileName((String)NOT_EXISTING_FILE);
            Assertions.fail((String)"Expecting KieEfestoCommonException thrown");
        }
        catch (Exception e) {
            Assertions.assertThat((boolean)(e instanceof KieEfestoCommonException)).isTrue();
        }
    }
}

