/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.cache;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.efesto.common.api.cache.EfestoClassKey;

class EfestoClassKeyTest {
    EfestoClassKeyTest() {
    }

    @Test
    void equalsMethod() {
        EfestoClassKey keyListString1 = new EfestoClassKey(List.class, new Type[]{String.class});
        EfestoClassKey keyListString2 = new EfestoClassKey(List.class, new Type[]{String.class});
        Assertions.assertThat((Object)keyListString1).isEqualTo((Object)keyListString2);
        EfestoClassKey keyArrayListString = new EfestoClassKey(ArrayList.class, new Type[]{String.class});
        Assertions.assertThat((Object)keyListString1).isNotEqualTo((Object)keyArrayListString);
        EfestoClassKey keyMapStringInteger1 = new EfestoClassKey(Map.class, new Type[]{String.class, Integer.class});
        EfestoClassKey keyMapStringInteger2 = new EfestoClassKey(Map.class, new Type[]{String.class, Integer.class});
        Assertions.assertThat((Object)keyMapStringInteger1).isEqualTo((Object)keyMapStringInteger2);
        EfestoClassKey keyHashMapStringInteger = new EfestoClassKey(HashMap.class, new Type[]{String.class, Integer.class});
        Assertions.assertThat((Object)keyMapStringInteger1).isNotEqualTo((Object)keyHashMapStringInteger);
        EfestoClassKey keyMapIntegerString1 = new EfestoClassKey(Map.class, new Type[]{Integer.class, String.class});
        Assertions.assertThat((Object)keyMapIntegerString1).isNotEqualTo((Object)keyMapStringInteger1);
    }

    @Test
    void equalsExtender() {
        EfestoClassKey keyArrayListString = new EfestoClassKey(ArrayList.class, new Type[]{String.class});
        EfestoClassKey keyArrayListExtender = new EfestoClassKey(ArrayListExtender.class, new Type[0]);
        Assertions.assertThat((Object)keyArrayListString).isNotEqualTo((Object)keyArrayListExtender);
    }

    @Test
    void equalsBaseInputMethod() {
        EfestoClassKey keyListString1 = new EfestoClassKey(List.class, new Type[]{String.class});
        EfestoClassKey keyListString2 = new EfestoClassKey(List.class, new Type[]{String.class});
        Assertions.assertThat((Object)keyListString1).isEqualTo((Object)keyListString2);
        EfestoClassKey keyArrayListString = new EfestoClassKey(ArrayList.class, new Type[]{String.class});
        Assertions.assertThat((Object)keyListString1).isNotEqualTo((Object)keyArrayListString);
        EfestoClassKey keyMapStringInteger1 = new EfestoClassKey(Map.class, new Type[]{String.class, Integer.class});
        EfestoClassKey keyMapStringInteger2 = new EfestoClassKey(Map.class, new Type[]{String.class, Integer.class});
        Assertions.assertThat((Object)keyMapStringInteger1).isEqualTo((Object)keyMapStringInteger2);
        EfestoClassKey keyHashMapStringInteger = new EfestoClassKey(HashMap.class, new Type[]{String.class, Integer.class});
        Assertions.assertThat((Object)keyMapStringInteger1).isNotEqualTo((Object)keyHashMapStringInteger);
        EfestoClassKey keyMapIntegerString1 = new EfestoClassKey(Map.class, new Type[]{Integer.class, String.class});
        Assertions.assertThat((Object)keyMapIntegerString1).isNotEqualTo((Object)keyMapStringInteger1);
    }

    @Test
    void setOfKeys() {
        HashSet<EfestoClassKey> set = new HashSet<EfestoClassKey>();
        EfestoClassKey keyListString1 = new EfestoClassKey(List.class, new Type[]{String.class});
        set.add(keyListString1);
        EfestoClassKey keyListString2 = new EfestoClassKey(List.class, new Type[]{String.class});
        Assertions.assertThat(set).contains((Object[])new EfestoClassKey[]{keyListString2});
        set.add(keyListString2);
        Assertions.assertThat(set).hasSize(1);
        EfestoClassKey keyArrayListString = new EfestoClassKey(ArrayList.class, new Type[]{String.class});
        Assertions.assertThat(set).doesNotContain((Object[])new EfestoClassKey[]{keyArrayListString});
        set.add(keyArrayListString);
        Assertions.assertThat(set).hasSize(2);
        Assertions.assertThat(set).contains((Object[])new EfestoClassKey[]{keyArrayListString});
        set = new HashSet();
        EfestoClassKey keyMapStringInteger1 = new EfestoClassKey(Map.class, new Type[]{String.class, Integer.class});
        set.add(keyMapStringInteger1);
        EfestoClassKey keyMapStringInteger2 = new EfestoClassKey(Map.class, new Type[]{String.class, Integer.class});
        Assertions.assertThat(set).contains((Object[])new EfestoClassKey[]{keyMapStringInteger2});
        set.add(keyMapStringInteger2);
        Assertions.assertThat(set).hasSize(1);
        EfestoClassKey keyMapIntegerString = new EfestoClassKey(Map.class, new Type[]{Integer.class, String.class});
        Assertions.assertThat(set).doesNotContain((Object[])new EfestoClassKey[]{keyMapIntegerString});
        set.add(keyMapIntegerString);
        Assertions.assertThat(set).hasSize(2);
        Assertions.assertThat(set).contains((Object[])new EfestoClassKey[]{keyMapIntegerString});
    }

    @Test
    void mapOfKeys() {
        HashMap<EfestoClassKey, String> map = new HashMap<EfestoClassKey, String>();
        EfestoClassKey keyListString1 = new EfestoClassKey(List.class, new Type[]{String.class});
        map.put(keyListString1, "");
        EfestoClassKey keyListString2 = new EfestoClassKey(List.class, new Type[]{String.class});
        Assertions.assertThat(map).containsKey((Object)keyListString2);
        map.put(keyListString2, "");
        Assertions.assertThat(map).hasSize(1);
        EfestoClassKey keyArrayListString = new EfestoClassKey(ArrayList.class, new Type[]{String.class});
        Assertions.assertThat(map).doesNotContainKey((Object)keyArrayListString);
        map.put(keyArrayListString, "");
        Assertions.assertThat(map).hasSize(2);
        Assertions.assertThat(map).containsKey((Object)keyArrayListString);
        map = new HashMap();
        EfestoClassKey keyMapStringInteger1 = new EfestoClassKey(Map.class, new Type[]{String.class, Integer.class});
        map.put(keyMapStringInteger1, "");
        EfestoClassKey keyMapStringInteger2 = new EfestoClassKey(Map.class, new Type[]{String.class, Integer.class});
        Assertions.assertThat(map).containsKey((Object)keyMapStringInteger2);
        map.put(keyMapStringInteger2, "");
        Assertions.assertThat(map).hasSize(1);
        EfestoClassKey keyMapIntegerString = new EfestoClassKey(Map.class, new Type[]{Integer.class, String.class});
        Assertions.assertThat(map).doesNotContainKey((Object)keyMapIntegerString);
        map.put(keyMapIntegerString, "");
        Assertions.assertThat(map).hasSize(2);
        Assertions.assertThat(map).containsKey((Object)keyMapIntegerString);
    }

    @Test
    void getActualTypeArguments() {
        List<Type> typeArguments = Arrays.asList(String.class, Boolean.class, Long.class);
        EfestoClassKey keyListWithTypes = new EfestoClassKey(List.class, typeArguments.toArray(new Type[0]));
        Object[] retrieved = keyListWithTypes.getActualTypeArguments();
        Assertions.assertThat((Object[])retrieved).isNotNull();
        Assertions.assertThat((Object[])retrieved).hasSameSizeAs(typeArguments);
        Assertions.assertThat(typeArguments).containsAll(Arrays.asList(retrieved));
        typeArguments = Collections.emptyList();
        EfestoClassKey keyListWithEmptyTypes = new EfestoClassKey(List.class, typeArguments.toArray(new Type[0]));
        retrieved = keyListWithEmptyTypes.getActualTypeArguments();
        Assertions.assertThat((Object[])retrieved).isNotNull();
        Assertions.assertThat((Object[])retrieved).isEmpty();
        EfestoClassKey keyListWithoutTypes = new EfestoClassKey(List.class, new Type[0]);
        retrieved = keyListWithoutTypes.getActualTypeArguments();
        Assertions.assertThat((Object[])retrieved).isNotNull();
        Assertions.assertThat((Object[])retrieved).isEmpty();
    }

    @Test
    void getRawType() {
        Class<List> rawType = List.class;
        List<Type> typeArguments = Arrays.asList(String.class, Boolean.class, Long.class);
        EfestoClassKey efestoClassKey = new EfestoClassKey(rawType, typeArguments.toArray(new Type[0]));
        Type retrieved = efestoClassKey.getRawType();
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((Object)retrieved).isEqualTo(rawType);
    }

    static class ArrayListExtender
    extends ArrayList<String> {
        ArrayListExtender() {
        }
    }
}

