/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.identifiers;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.efesto.common.api.identifiers.AppRoot;
import org.kie.efesto.common.api.identifiers.ComponentRoot;
import org.kie.efesto.common.api.identifiers.LocalUri;
import org.kie.efesto.common.api.identifiers.ReflectiveAppRoot;
import org.kie.efesto.common.api.identifiers.componentroots.ComponentRootA;

class ReflectiveAppRootTest {
    private static AppRoot appRoot;

    ReflectiveAppRootTest() {
    }

    @BeforeAll
    public static void setup() {
        appRoot = new ReflectiveAppRoot("testing");
    }

    @Test
    void constructorNoName() {
        ReflectiveAppRoot retrieved = new ReflectiveAppRoot();
        Assertions.assertThat((String)retrieved.name()).isEqualTo("efesto-app");
    }

    @Test
    void constructorName() {
        String name = "name";
        ReflectiveAppRoot retrieved = new ReflectiveAppRoot(name);
        Assertions.assertThat((String)retrieved.name()).isEqualTo(name);
    }

    @Test
    void get() {
        String fileName = "fileName";
        String name = "name";
        LocalUri retrieved = ((ComponentRootA)appRoot.get(ComponentRootA.class)).get(fileName, name).toLocalId().asLocalUri();
        ((ComponentRootA)appRoot.get(ComponentRootA.class)).get(fileName, name).toLocalId();
        Assertions.assertThat((Object)retrieved).isNotNull();
        String expected = String.format("/%1$s/%2$s/%3$s", "testingcomponentA", fileName, name);
        Assertions.assertThat((String)retrieved.path()).isEqualTo(expected);
    }

    @Test
    void getPrivateConstructorImplementation() {
        IllegalArgumentException thrown = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> appRoot.get(ComponentRootPrivateConstructor.class), (String)"Expected constructor to throw, but it didn't");
        String expectedMessage = "java.lang.NoSuchMethodException";
        Assertions.assertThat((String)thrown.getMessage()).startsWith((CharSequence)expectedMessage);
    }

    @Test
    void getNoDefaultConstructorImplementation() {
        IllegalArgumentException thrown = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> appRoot.get(ComponentRootNoDefaultConstructor.class), (String)"Expected constructor to throw, but it didn't");
        String expectedMessage = "java.lang.NoSuchMethodException";
        Assertions.assertThat((String)thrown.getMessage()).startsWith((CharSequence)expectedMessage);
    }

    private static class ComponentRootNoDefaultConstructor
    implements ComponentRoot {
        private final String arg;

        public ComponentRootNoDefaultConstructor(String arg) {
            this.arg = arg;
        }
    }

    private static class ComponentRootPrivateConstructor
    implements ComponentRoot {
        private ComponentRootPrivateConstructor() {
        }
    }
}

