/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.efesto.common.api.io.IndexFile;
import org.kie.efesto.common.api.io.MemoryFile;
import org.kie.efesto.common.api.utils.MemoryFileUtils;

class MemoryFileTest {
    private static final String FILE_NAME = "IndexFile.test_json";
    private static final String FILE_PATH = "./IndexFile.test_json";
    private static File testingFile;
    private static byte[] content;

    MemoryFileTest() {
    }

    @BeforeAll
    public static void setup() throws IOException {
        testingFile = (File)MemoryFileUtils.getFileFromFileNameOrFilePath((String)FILE_NAME, (String)FILE_PATH).map(IndexFile::new).orElseThrow(() -> new RuntimeException("Failed to retrieve IndexFile.test_json"));
        Assertions.assertThat((File)testingFile).exists();
        Assertions.assertThat((File)testingFile).canRead();
        content = Files.readAllBytes(testingFile.toPath());
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])content).isNotNull()).isNotEmpty();
    }

    @Test
    void instantiateFromPath() throws IOException {
        MemoryFile retrieved = new MemoryFile(testingFile.toPath());
        this.commonVerifyMemoryFile(retrieved);
    }

    @Test
    void instantiateFromURL() throws IOException {
        MemoryFile retrieved = new MemoryFile(testingFile.toURI().toURL());
        this.commonVerifyMemoryFile(retrieved);
    }

    private void commonVerifyMemoryFile(MemoryFile toVerify) {
        Assertions.assertThat((File)toVerify).exists();
        Assertions.assertThat((File)toVerify).canRead();
        Assertions.assertThat((boolean)toVerify.canWrite()).isFalse();
        Assertions.assertThat((String)toVerify.getName()).isEqualTo(FILE_NAME);
        Assertions.assertThat((long)toVerify.length()).isEqualTo((long)content.length);
        Assertions.assertThat((byte[])toVerify.getContent()).isEqualTo((Object)content);
    }
}

