/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.utils;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;
import org.kie.efesto.common.api.io.MemoryFile;
import org.kie.efesto.common.api.utils.MemoryFileUtils;

class MemoryFileUtilsTest {
    private static final String TEST_FILE = "TestingEmptyFile.txt";
    private static final String NOT_EXISTING_FILE = "NotExistingFile.txt";
    private static final String NOT_EMPTY_FILE = "IndexFile.test_json";

    MemoryFileUtilsTest() {
    }

    @Test
    void getFileFromFileNameOrFilePathExisting() {
        Optional retrieved = MemoryFileUtils.getFileFromFileNameOrFilePath((String)TEST_FILE, (String)TEST_FILE);
        ((OptionalAssert)Assertions.assertThat((Optional)retrieved).isNotNull()).isNotEmpty();
        String path = String.format("target%1$stest-classes%1$s%2$s", File.separator, TEST_FILE);
        retrieved = MemoryFileUtils.getFileFromFileNameOrFilePath((String)NOT_EXISTING_FILE, (String)path);
        ((OptionalAssert)Assertions.assertThat((Optional)retrieved).isNotNull()).isNotEmpty();
        retrieved = MemoryFileUtils.getFileFromFileNameOrFilePath((String)path, (String)NOT_EXISTING_FILE);
        ((OptionalAssert)Assertions.assertThat((Optional)retrieved).isNotNull()).isNotEmpty();
    }

    @Test
    void getFileFromFileNameOrFilePathNotExisting() {
        Optional retrieved = MemoryFileUtils.getFileFromFileNameOrFilePath((String)NOT_EXISTING_FILE, (String)NOT_EXISTING_FILE);
        ((OptionalAssert)Assertions.assertThat((Optional)retrieved).isNotNull()).isEmpty();
    }

    @Test
    void getFileFromURL() throws IOException {
        URL url = MemoryFileUtilsTest.getJarUrl();
        Assertions.assertThat((URL)url).isNotNull();
        Optional retrieved = MemoryFileUtils.getFileFromURL((URL)url);
        ((OptionalAssert)Assertions.assertThat((Optional)retrieved).isNotNull()).isPresent();
        Assertions.assertThat((File)((File)retrieved.get())).isInstanceOf(MemoryFile.class);
        Assertions.assertThat((File)((File)retrieved.get())).canRead();
        url = MemoryFileUtilsTest.getResourceUrl();
        Assertions.assertThat((URL)url).isNotNull();
        retrieved = MemoryFileUtils.getFileFromURL((URL)url);
        ((OptionalAssert)Assertions.assertThat((Optional)retrieved).isNotNull()).isPresent();
        Assertions.assertThat((File)((File)retrieved.get())).isInstanceOf(File.class);
        Assertions.assertThat((File)((File)retrieved.get())).canRead();
    }

    @Test
    void getOptionalFileFromJar() throws IOException {
        URL jarUrl = MemoryFileUtilsTest.getJarUrl();
        Assertions.assertThat((URL)jarUrl).isNotNull();
        Optional retrieved = MemoryFileUtils.getOptionalFileFromJar((URL)jarUrl);
        Assertions.assertThat((Optional)retrieved).isNotNull();
        Assertions.assertThat((boolean)retrieved.isPresent()).isTrue();
        Assertions.assertThat((Optional)retrieved).get().isInstanceOf(MemoryFile.class);
    }

    @Test
    void getOptionalFileFromResource() {
        URL resourceUrl = MemoryFileUtilsTest.getResourceUrl();
        Optional retrieved = MemoryFileUtils.getOptionalFileFromResource((URL)resourceUrl);
        Assertions.assertThat((Optional)retrieved).isNotNull();
        Assertions.assertThat((boolean)retrieved.isPresent()).isTrue();
        Assertions.assertThat((Optional)retrieved).get().isInstanceOf(MemoryFile.class);
    }

    @Test
    void getOptionalFileFromURLFile() {
        URL resourceUrl = MemoryFileUtilsTest.getResourceUrl();
        Optional retrieved = MemoryFileUtils.getOptionalFileFromURLFile((URL)resourceUrl);
        Assertions.assertThat((Optional)retrieved).isNotNull();
        Assertions.assertThat((boolean)retrieved.isPresent()).isTrue();
        Assertions.assertThat((Optional)retrieved).get().isInstanceOf(File.class);
    }

    @Test
    void getFileFromResource() throws IOException {
        URL resourceUrl = MemoryFileUtilsTest.getResourceUrl();
        File retrieved = MemoryFileUtils.getFileFromResource((URL)resourceUrl);
        Assertions.assertThat((File)retrieved).isNotNull();
        Assertions.assertThat((File)retrieved).isInstanceOf(MemoryFile.class);
        Assertions.assertThat((File)retrieved).canRead();
    }

    @Test
    void getFileFromJar() throws URISyntaxException, IOException {
        URL jarUrl = MemoryFileUtilsTest.getJarUrl();
        Assertions.assertThat((URL)jarUrl).isNotNull();
        File retrieved = MemoryFileUtils.getFileFromJar((URL)jarUrl);
        Assertions.assertThat((File)retrieved).isNotNull();
        Assertions.assertThat((File)retrieved).isInstanceOf(MemoryFile.class);
        Assertions.assertThat((File)retrieved).canRead();
    }

    private static URL getResourceUrl() {
        URL toReturn = Thread.currentThread().getContextClassLoader().getResource(NOT_EMPTY_FILE);
        Assertions.assertThat((URL)toReturn).isNotNull();
        return toReturn;
    }

    private static URL getJarUrl() throws MalformedURLException {
        URL retrieved = Thread.currentThread().getContextClassLoader().getResource("TestJar.jar");
        Assertions.assertThat((URL)retrieved).isNotNull();
        String newString = "jar:" + retrieved + "!/IndexFile.testb_json";
        return new URL(newString);
    }
}

