/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.identifiers;

import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringTokenizer;
import org.kie.efesto.common.api.identifiers.LocalUri;
import org.kie.efesto.common.api.identifiers.LocalUriId;

public class ModelLocalUriId
extends LocalUriId
implements Serializable {
    private static final long serialVersionUID = 2473381132658366922L;
    private final String model;
    private final String basePath;
    private final String fullPath;

    public ModelLocalUriId(LocalUri path) {
        super(path);
        this.model = ModelLocalUriId.getModel(path);
        this.basePath = ModelLocalUriId.getBasePath(path, this.model);
        this.fullPath = path.path();
    }

    public String model() {
        return this.model;
    }

    public String basePath() {
        return this.basePath;
    }

    public String fullPath() {
        return this.fullPath;
    }

    public ModelLocalUriId asModelLocalUriId() {
        return this.getClass().equals(ModelLocalUriId.class) ? this : new ModelLocalUriId(this.asLocalUri());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof ModelLocalUriId)) {
            return false;
        }
        ModelLocalUriId that = (ModelLocalUriId)o;
        return Objects.equals(this.model, that.model) && Objects.equals(this.basePath, that.basePath) && Objects.equals(this.fullPath, that.fullPath);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.model, this.basePath, this.fullPath);
    }

    static LocalUri.LocalUriPathComponent getFirstLocalUriPathComponent(LocalUri localUri) {
        if (localUri.parent() instanceof LocalUri.LocalUriPathComponent) {
            return ModelLocalUriId.getFirstLocalUriPathComponent(localUri.parent());
        }
        return localUri instanceof LocalUri.LocalUriPathComponent ? (LocalUri.LocalUriPathComponent)localUri : null;
    }

    static String getModel(LocalUri path) {
        LocalUri.LocalUriPathComponent firstLocalUriPathComponent = ModelLocalUriId.getFirstLocalUriPathComponent(path);
        return firstLocalUriPathComponent != null ? firstLocalUriPathComponent.component : null;
    }

    static String getBasePath(LocalUri path, String model) {
        String uriPath = path.path();
        if (model == null || model.isEmpty()) {
            return uriPath;
        }
        String start = "/" + model;
        return uriPath.substring(uriPath.indexOf(start) + start.length());
    }

    protected static LocalUri appendBasePath(LocalUri parent, String basePath) {
        StringTokenizer tok = new StringTokenizer(basePath, "/");
        while (tok.hasMoreTokens()) {
            parent = parent.append(ModelLocalUriId.decodeString(tok.nextToken()));
        }
        return parent;
    }

    private static String decodeString(String toDecode) {
        return URLDecoder.decode(toDecode, StandardCharsets.UTF_8);
    }
}

