/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.compilationmanager.api.model;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.kie.efesto.common.api.listener.EfestoListener;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationContext;
import org.kie.efesto.compilationmanager.api.service.KieCompilerService;
import org.kie.memorycompiler.JavaConfiguration;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.memorycompiler.KieMemoryCompilerException;

public class EfestoCompilationContextImpl<T extends EfestoListener>
implements EfestoCompilationContext<T> {
    protected final KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader;

    protected EfestoCompilationContextImpl(KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader) {
        this.memoryCompilerClassLoader = memoryCompilerClassLoader;
        this.prepareClassLoader();
    }

    private void prepareClassLoader() {
        Set friKeySet = this.friKeySet();
        friKeySet.stream().map(arg_0 -> ((EfestoCompilationContextImpl)this).getGeneratedClasses(arg_0)).forEach(generatedClasses -> generatedClasses.forEach((arg_0, arg_1) -> ((KieMemoryCompiler.MemoryCompilerClassLoader)this.memoryCompilerClassLoader).addCodeIfAbsent(arg_0, arg_1)));
    }

    @Override
    public Map<String, byte[]> compileClasses(Map<String, String> sourcesMap) {
        return KieMemoryCompiler.compileNoLoad(sourcesMap, (ClassLoader)this.memoryCompilerClassLoader, (JavaConfiguration.CompilerType)JavaConfiguration.CompilerType.NATIVE);
    }

    @Override
    public void loadClasses(Map<String, byte[]> compiledClassesMap) {
        for (Map.Entry<String, byte[]> entry : compiledClassesMap.entrySet()) {
            this.memoryCompilerClassLoader.addCode(entry.getKey(), entry.getValue());
            try {
                this.memoryCompilerClassLoader.loadClass(entry.getKey());
            }
            catch (ClassNotFoundException e) {
                throw new KieMemoryCompilerException(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public ServiceLoader<KieCompilerService> getKieCompilerServiceLoader() {
        return ServiceLoader.load(KieCompilerService.class, (ClassLoader)this.memoryCompilerClassLoader);
    }

    @Override
    public byte[] getCode(String name) {
        return this.memoryCompilerClassLoader.getCode(name);
    }
}

