/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.compilationmanager.api.model;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.efesto.common.api.exceptions.KieEfestoCommonException;
import org.kie.efesto.common.api.identifiers.LocalUri;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.compilationmanager.api.model.EfestoRedirectOutput;

class EfestoRedirectOutputTest {
    private static ModelLocalUriId modelLocalUriId;

    EfestoRedirectOutputTest() {
    }

    @BeforeAll
    public static void setup() {
        String path = "/example/some-id/instances/some-instance-id";
        LocalUri parsed = LocalUri.parse((String)path);
        modelLocalUriId = new ModelLocalUriId(parsed);
    }

    @Test
    void constructor() {
        String targetEngine = "targetEngine";
        EfestoRedirectOutput retrieved = new EfestoRedirectOutput(modelLocalUriId, targetEngine, null){};
        Assertions.assertThat((Object)retrieved.getModelLocalUriId()).isEqualTo((Object)modelLocalUriId);
        Assertions.assertThat((List)retrieved.getFullClassNames()).isNull();
    }

    @Test
    void constructorMissingRequiredTarget() {
        KieEfestoCommonException thrown = (KieEfestoCommonException)org.junit.jupiter.api.Assertions.assertThrows(KieEfestoCommonException.class, () -> new EfestoRedirectOutput(modelLocalUriId, null, "content"){}, (String)"Expected constructor to throw, but it didn't");
        String expectedMessage = "Missing required target";
        Assertions.assertThat((String)thrown.getMessage()).isEqualTo(expectedMessage);
    }

    @Test
    void constructorEmptyTarget() {
        KieEfestoCommonException thrown = (KieEfestoCommonException)org.junit.jupiter.api.Assertions.assertThrows(KieEfestoCommonException.class, () -> new EfestoRedirectOutput(modelLocalUriId, "", "content"){}, (String)"Expected constructor to throw, but it didn't");
        String expectedMessage = "Missing required target";
        Assertions.assertThat((String)thrown.getMessage()).isEqualTo(expectedMessage);
    }

    @Test
    void getTargetEngine() {
        String targetEngine = "targetEngine";
        EfestoRedirectOutput retrieved = new EfestoRedirectOutput(modelLocalUriId, targetEngine, null){};
        Assertions.assertThat((String)retrieved.getTargetEngine()).isEqualTo(targetEngine);
    }

    @Test
    void getContent() {
        String targetEngine = "targetEngine";
        String content = "content";
        EfestoRedirectOutput retrieved = new EfestoRedirectOutput(modelLocalUriId, targetEngine, content){};
        Assertions.assertThat((Object)retrieved.getContent()).isEqualTo((Object)content);
    }
}

