/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.consumer;

import java.util.Queue;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.hacep.EnvConfig;
import org.kie.hacep.consumer.CommandHandler;
import org.kie.hacep.consumer.KieContainerUtils;
import org.kie.hacep.core.GlobalStatus;
import org.kie.hacep.core.KieSessionContext;
import org.kie.hacep.core.infra.SessionSnapshooter;
import org.kie.hacep.core.infra.SnapshotInfos;
import org.kie.hacep.core.infra.consumer.ConsumerHandler;
import org.kie.hacep.core.infra.consumer.ItemToProcess;
import org.kie.hacep.core.infra.election.State;
import org.kie.hacep.util.ConsumerUtilsCore;
import org.kie.hacep.util.PrinterUtil;
import org.kie.remote.DroolsExecutor;
import org.kie.remote.command.RemoteCommand;
import org.kie.remote.command.VisitableCommand;
import org.kie.remote.command.VisitorCommand;
import org.kie.remote.impl.producer.Producer;
import org.kie.remote.message.ControlMessage;
import org.kie.remote.message.Message;
import org.kie.remote.util.SerializationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DroolsConsumerHandler
implements ConsumerHandler {
    private static final Logger logger = LoggerFactory.getLogger(DroolsConsumerHandler.class);
    private Logger loggerForTest;
    private Producer producer;
    private SessionSnapshooter sessionSnapShooter;
    private EnvConfig envConfig;
    private KieSessionContext kieSessionContext;
    private CommandHandler commandHandler;
    private SnapshotInfos snapshotInfos;
    private boolean shutdown;

    public DroolsConsumerHandler(Producer producer, EnvConfig envConfig, SessionSnapshooter snapShooter, ConsumerUtilsCore consumerUtilsCore) {
        this.envConfig = envConfig;
        this.sessionSnapShooter = snapShooter;
        this.initializeKieSessionContext();
        this.producer = producer;
        this.commandHandler = new CommandHandler(this.kieSessionContext, this.envConfig, producer, this.sessionSnapShooter, consumerUtilsCore);
        if (this.envConfig.isUnderTest()) {
            this.loggerForTest = PrinterUtil.getKafkaLoggerForTest(envConfig);
        }
    }

    private void initializeKieSessionContext() {
        if (this.envConfig.isSkipOnDemandSnapshot()) {
            this.initializeSessionContextWithSnapshotCheck();
        } else {
            this.createAndInitializeSessionContextWithoutSnapshot();
        }
    }

    private void initializeSessionContextWithSnapshotCheck() {
        this.snapshotInfos = this.sessionSnapShooter.deserialize();
        if (this.snapshotInfos != null) {
            this.initializeSessionContextFromSnapshot();
        } else {
            this.createAndInitializeSessionContextWithoutSnapshot();
        }
    }

    private void createAndInitializeSessionContextWithoutSnapshot() {
        KieServices srv = KieServices.get();
        if (srv == null) {
            throw new IllegalStateException("KieService is null");
        }
        KieContainer kieContainer = KieContainerUtils.getKieContainer(this.envConfig, srv);
        this.kieSessionContext = new KieSessionContext();
        this.kieSessionContext.init(kieContainer, kieContainer.newKieSession());
    }

    private void initializeSessionContextFromSnapshot() {
        if (this.snapshotInfos.getKieSession() != null) {
            if (logger.isInfoEnabled()) {
                logger.info("Applying snapshot Session");
            }
        } else {
            throw new IllegalStateException("The Serialized Session isn't present");
        }
        this.kieSessionContext = new KieSessionContext();
        this.kieSessionContext.initFromSnapshot(this.snapshotInfos);
    }

    public boolean initializeKieSessionFromSnapshotOnDemand(EnvConfig config, SnapshotInfos snapshotInfos) {
        if (!config.isSkipOnDemandSnapshot()) {
            this.snapshotInfos = snapshotInfos;
            this.initializeSessionContextFromSnapshot();
            return true;
        }
        return false;
    }

    @Override
    public void process(ItemToProcess item, State state) {
        RemoteCommand command = (RemoteCommand)SerializationUtil.deserialize((byte[])((byte[])item.getObject()));
        this.process(command, state);
    }

    @Override
    public void process(RemoteCommand command, State state) {
        if (this.envConfig.isUnderTest()) {
            this.loggerForTest.warn("DroolsConsumerHandler.process Remote command on process:{} state:{}", (Object)command, (Object)state);
        }
        if (state.equals((Object)State.LEADER)) {
            this.processCommand(command, state);
            Queue sideEffectsResults = DroolsExecutor.getInstance().getAndReset();
            if (this.envConfig.isUnderTest()) {
                this.loggerForTest.warn("DroolsConsumerHandler.process sideEffects:{}", (Object)sideEffectsResults);
            }
            ControlMessage newControlMessage = new ControlMessage(command.getId(), sideEffectsResults);
            if (this.envConfig.isUnderTest()) {
                this.loggerForTest.warn("DroolsConsumerHandler.process new ControlMessage sent to control topic:{}", (Object)newControlMessage);
            }
            this.producer.produceSync(this.envConfig.getControlTopicName(), command.getId(), (Message)newControlMessage);
            if (this.envConfig.isUnderTest()) {
                this.loggerForTest.warn("sideEffectOnLeader:{}", (Object)sideEffectsResults);
            }
        } else {
            this.processCommand(command, state);
        }
    }

    public void processSideEffectsOnReplica(Queue<Object> newSideEffects) {
        DroolsExecutor.getInstance().appendSideEffects(newSideEffects);
        if (this.envConfig.isUnderTest()) {
            this.loggerForTest.warn("sideEffectOnReplica:{}", newSideEffects);
        }
    }

    @Override
    public void processWithSnapshot(ItemToProcess item, State currentState) {
        if (logger.isInfoEnabled()) {
            logger.info("SNAPSHOT");
        }
        this.process(item, currentState);
        if (!this.shutdown) {
            this.sessionSnapShooter.serialize(this.kieSessionContext, item.getKey(), item.getOffset());
        }
    }

    @Override
    public void stop() {
        this.shutdown = true;
        if (this.kieSessionContext != null) {
            this.kieSessionContext.getKieSession().dispose();
        }
    }

    private void processCommand(RemoteCommand command, State state) {
        boolean execute;
        boolean bl = execute = state.equals((Object)State.LEADER) || command.isPermittedForReplicas();
        if (execute) {
            VisitableCommand visitable = (VisitableCommand)command;
            try {
                visitable.accept((VisitorCommand)this.commandHandler);
            }
            catch (Exception e) {
                GlobalStatus.setNodeLive(false);
                throw new IllegalStateException(e.getMessage(), e.getCause());
            }
        }
    }
}

