/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.core.infra.consumer;

import org.kie.hacep.core.infra.consumer.ConsumerHandler;
import org.kie.hacep.core.infra.consumer.ConsumerThread;
import org.kie.hacep.core.infra.consumer.EventConsumer;
import org.kie.hacep.core.infra.consumer.InfraCallback;
import org.kie.hacep.core.infra.election.LeadershipCallback;

public class ConsumerController {
    private EventConsumer consumer;
    private InfraCallback callback = new InfraCallback();
    private Thread thread;

    public ConsumerController(ConsumerHandler consumerHandler, EventConsumer consumer) {
        this.consumer = consumer;
        this.callback.setConsumer(consumer);
        this.consumer.initConsumer(consumerHandler);
    }

    public void start() {
        this.consumeEvents();
    }

    public void stop() {
        this.consumer.stop();
        this.stopConsumeEvents();
    }

    public EventConsumer getConsumer() {
        return this.consumer;
    }

    public LeadershipCallback getCallback() {
        return this.callback;
    }

    private void consumeEvents() {
        this.thread = new Thread(new ConsumerThread(this));
        this.thread.start();
    }

    private void stopConsumeEvents() {
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException ex) {
                this.thread.interrupt();
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }
    }
}

