/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.session;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.ClockType;
import org.drools.core.SessionConfiguration;
import org.drools.core.audit.WorkingMemoryLogger;
import org.drools.core.audit.event.LogEvent;
import org.drools.core.command.Interceptor;
import org.drools.core.command.runtime.process.CompleteWorkItemCommand;
import org.drools.core.command.runtime.process.GetProcessInstanceCommand;
import org.drools.core.command.runtime.process.RegisterWorkItemHandlerCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.process.core.Work;
import org.drools.core.process.core.impl.WorkImpl;
import org.drools.core.time.SessionPseudoClock;
import org.drools.persistence.SingleSessionCommandService;
import org.drools.persistence.infinispan.InfinispanTimeJobFactoryManager;
import org.drools.persistence.infinispan.ManualPersistInterceptor;
import org.drools.persistence.infinispan.processinstance.InfinispanWorkItemManagerFactory;
import org.drools.persistence.jpa.JpaJDKTimerService;
import org.drools.persistence.jta.JtaTransactionManager;
import org.jbpm.compiler.ProcessBuilderImpl;
import org.jbpm.persistence.InfinispanProcessPersistenceContextManager;
import org.jbpm.persistence.ManualPersistProcessInterceptor;
import org.jbpm.persistence.processinstance.InfinispanProcessInstanceManagerFactory;
import org.jbpm.persistence.processinstance.InfinispanSignalManagerFactory;
import org.jbpm.persistence.session.objects.TestWorkItemHandler;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.node.SubProcessNodeInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.definition.KnowledgePackage;
import org.kie.internal.event.KnowledgeRuntimeEventManager;
import org.kie.internal.logger.KnowledgeRuntimeLoggerFactory;

public class SingleSessionCommandServiceTest {
    private HashMap<String, Object> context;
    private Environment env;

    @Before
    public void setUp() {
        String testMethodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        this.context = testMethodName.startsWith("testPersistenceTimer") ? PersistenceUtil.setupWithPoolingDataSource("org.jbpm.persistence.jpa", false) : PersistenceUtil.setupWithPoolingDataSource("org.jbpm.persistence.jpa");
        this.env = PersistenceUtil.createEnvironment(this.context);
        this.env.set("org.kie.api.persistence.PersistenceContextManager", (Object)new InfinispanProcessPersistenceContextManager(this.env));
        this.env.set("org.kie.transaction.TransactionManager", (Object)new JtaTransactionManager(this.env.get("org.kie.transaction.Transaction"), this.env.get("org.kie.transaction.TransactionSynchronizationRegistry"), this.env.get("org.kie.transaction.TransactionManager")));
    }

    @After
    public void tearDown() {
        try {
            PersistenceUtil.cleanUp(this.context);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testPersistenceWorkItems() throws Exception {
        this.setUp();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        Collection<KnowledgePackage> kpkgs = this.getProcessWorkItems();
        kbase.addKnowledgePackages(kpkgs);
        Properties properties = new Properties();
        properties.setProperty("drools.commandService", SingleSessionCommandService.class.getName());
        properties.setProperty("drools.processInstanceManagerFactory", InfinispanProcessInstanceManagerFactory.class.getName());
        properties.setProperty("drools.workItemManagerFactory", InfinispanWorkItemManagerFactory.class.getName());
        properties.setProperty("drools.processSignalManagerFactory", InfinispanSignalManagerFactory.class.getName());
        properties.setProperty("drools.timerService", JpaJDKTimerService.class.getName());
        SessionConfiguration config = new SessionConfiguration(properties);
        SingleSessionCommandService service = this.createSingleSessionCommandService(kbase, config, this.env);
        long sessionId = service.getSessionId();
        this.registerWorkItemHandlers(service);
        StartProcessCommand startProcessCommand = new StartProcessCommand();
        startProcessCommand.setProcessId("org.drools.test.TestProcess");
        ProcessInstance processInstance = (ProcessInstance)service.execute((Command)startProcessCommand);
        System.out.println("Started process instance " + processInstance.getId());
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        service = this.createSingleSessionCommandService(sessionId, kbase, config, this.env);
        this.registerWorkItemHandlers(service);
        GetProcessInstanceCommand getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNotNull((Object)processInstance);
        service.dispose();
        service = this.createSingleSessionCommandService(sessionId, kbase, config, this.env);
        this.registerWorkItemHandlers(service);
        CompleteWorkItemCommand completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        service = this.createSingleSessionCommandService(sessionId, kbase, config, this.env);
        this.registerWorkItemHandlers(service);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNotNull((Object)processInstance);
        service.dispose();
        service = this.createSingleSessionCommandService(sessionId, kbase, config, this.env);
        this.registerWorkItemHandlers(service);
        completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        service = this.createSingleSessionCommandService(sessionId, kbase, config, this.env);
        this.registerWorkItemHandlers(service);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNotNull((Object)processInstance);
        service.dispose();
        service = this.createSingleSessionCommandService(sessionId, kbase, config, this.env);
        this.registerWorkItemHandlers(service);
        completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        service.dispose();
        service = this.createSingleSessionCommandService(sessionId, kbase, config, this.env);
        this.registerWorkItemHandlers(service);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNull((Object)processInstance);
        service.dispose();
    }

    @Test
    public void testPersistenceWorkItemsUserTransaction() throws Exception {
        this.setUp();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        Collection<KnowledgePackage> kpkgs = this.getProcessWorkItems();
        kbase.addKnowledgePackages(kpkgs);
        Properties properties = new Properties();
        properties.setProperty("drools.commandService", SingleSessionCommandService.class.getName());
        properties.setProperty("drools.processInstanceManagerFactory", InfinispanProcessInstanceManagerFactory.class.getName());
        properties.setProperty("drools.workItemManagerFactory", InfinispanWorkItemManagerFactory.class.getName());
        properties.setProperty("drools.processSignalManagerFactory", InfinispanSignalManagerFactory.class.getName());
        properties.setProperty("drools.timerService", JpaJDKTimerService.class.getName());
        SessionConfiguration config = new SessionConfiguration(properties);
        SingleSessionCommandService service = this.createSingleSessionCommandService(kbase, config, this.env);
        long sessionId = service.getSessionId();
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        StartProcessCommand startProcessCommand = new StartProcessCommand();
        startProcessCommand.setProcessId("org.drools.test.TestProcess");
        ProcessInstance processInstance = (ProcessInstance)service.execute((Command)startProcessCommand);
        System.out.println("Started process instance " + processInstance.getId());
        ut.commit();
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        service = this.createSingleSessionCommandService(sessionId, kbase, config, this.env);
        ut.begin();
        GetProcessInstanceCommand getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNotNull((Object)processInstance);
        ut.commit();
        service.dispose();
        service = this.createSingleSessionCommandService(sessionId, kbase, config, this.env);
        ut.begin();
        CompleteWorkItemCommand completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        ut.commit();
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        service = this.createSingleSessionCommandService(sessionId, kbase, config, this.env);
        ut.begin();
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        ut.commit();
        Assert.assertNotNull((Object)processInstance);
        service.dispose();
        service = this.createSingleSessionCommandService(sessionId, kbase, config, this.env);
        ut.begin();
        completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        ut.commit();
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        service = this.createSingleSessionCommandService(sessionId, kbase, config, this.env);
        ut.begin();
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        ut.commit();
        Assert.assertNotNull((Object)processInstance);
        service.dispose();
        service = this.createSingleSessionCommandService(sessionId, kbase, config, this.env);
        ut.begin();
        completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        ut.commit();
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        service.dispose();
        service = this.createSingleSessionCommandService(sessionId, kbase, config, this.env);
        ut.begin();
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        ut.commit();
        Assert.assertNull((Object)processInstance);
        service.dispose();
    }

    private Collection<KnowledgePackage> getProcessWorkItems() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.TestProcess");
        process.setName("TestProcess");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        ActionNode actionNode = new ActionNode();
        actionNode.setId(2L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setId(3L);
        workItemNode.setName("WorkItem1");
        WorkImpl work = new WorkImpl();
        work.setName("MyWork");
        workItemNode.setWork((Work)work);
        process.addNode((Node)workItemNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)workItemNode, "DROOLS_DEFAULT");
        WorkItemNode workItemNode2 = new WorkItemNode();
        workItemNode2.setId(4L);
        workItemNode2.setName("WorkItem2");
        work = new WorkImpl();
        work.setName("MyWork");
        workItemNode2.setWork((Work)work);
        process.addNode((Node)workItemNode2);
        new ConnectionImpl((Node)workItemNode, "DROOLS_DEFAULT", (Node)workItemNode2, "DROOLS_DEFAULT");
        WorkItemNode workItemNode3 = new WorkItemNode();
        workItemNode3.setId(5L);
        workItemNode3.setName("WorkItem3");
        work = new WorkImpl();
        work.setName("MyWork");
        workItemNode3.setWork((Work)work);
        process.addNode((Node)workItemNode3);
        new ConnectionImpl((Node)workItemNode2, "DROOLS_DEFAULT", (Node)workItemNode3, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)workItemNode3, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        KnowledgeBuilderImpl packageBuilder = new KnowledgeBuilderImpl();
        ProcessBuilderImpl processBuilder = new ProcessBuilderImpl(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        ArrayList<KnowledgePackage> list = new ArrayList<KnowledgePackage>();
        list.add((KnowledgePackage)packageBuilder.getPackage());
        return list;
    }

    @Test
    public void testPersistenceSubProcess() {
        this.setUp();
        Properties properties = new Properties();
        properties.setProperty("drools.commandService", SingleSessionCommandService.class.getName());
        properties.setProperty("drools.processInstanceManagerFactory", InfinispanProcessInstanceManagerFactory.class.getName());
        properties.setProperty("drools.workItemManagerFactory", InfinispanWorkItemManagerFactory.class.getName());
        properties.setProperty("drools.processSignalManagerFactory", InfinispanSignalManagerFactory.class.getName());
        properties.setProperty("drools.timerService", JpaJDKTimerService.class.getName());
        SessionConfiguration config = new SessionConfiguration(properties);
        KnowledgeBase ruleBase = KnowledgeBaseFactory.newKnowledgeBase();
        InternalKnowledgePackage pkg = this.getProcessSubProcess();
        ((KnowledgeBaseImpl)ruleBase).addPackage(pkg);
        SingleSessionCommandService service = this.createSingleSessionCommandService(ruleBase, config, this.env);
        long sessionId = service.getSessionId();
        StartProcessCommand startProcessCommand = new StartProcessCommand();
        startProcessCommand.setProcessId("org.drools.test.TestProcess");
        RuleFlowProcessInstance processInstance = (RuleFlowProcessInstance)service.execute((Command)startProcessCommand);
        System.out.println("Started process instance " + processInstance.getId());
        long processInstanceId = processInstance.getId();
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        service = this.createSingleSessionCommandService(sessionId, ruleBase, config, this.env);
        GetProcessInstanceCommand getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstanceId));
        processInstance = (RuleFlowProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNotNull((Object)processInstance);
        Collection nodeInstances = processInstance.getNodeInstances();
        Assert.assertEquals((long)1L, (long)nodeInstances.size());
        SubProcessNodeInstance subProcessNodeInstance = (SubProcessNodeInstance)nodeInstances.iterator().next();
        long subProcessInstanceId = subProcessNodeInstance.getProcessInstanceId();
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(subProcessInstanceId));
        RuleFlowProcessInstance subProcessInstance = (RuleFlowProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNotNull((Object)subProcessInstance);
        service.dispose();
        service = this.createSingleSessionCommandService(sessionId, ruleBase, config, this.env);
        CompleteWorkItemCommand completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        service.dispose();
        service = this.createSingleSessionCommandService(sessionId, ruleBase, config, this.env);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(subProcessInstanceId));
        subProcessInstance = (RuleFlowProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNull((Object)subProcessInstance);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstanceId));
        processInstance = (RuleFlowProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNull((Object)processInstance);
        service.dispose();
    }

    private InternalKnowledgePackage getProcessSubProcess() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.TestProcess");
        process.setName("TestProcess");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        ActionNode actionNode = new ActionNode();
        actionNode.setId(2L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        SubProcessNode subProcessNode = new SubProcessNode();
        subProcessNode.setId(3L);
        subProcessNode.setName("SubProcess");
        subProcessNode.setProcessId("org.drools.test.SubProcess");
        process.addNode((Node)subProcessNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)subProcessNode, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(4L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)subProcessNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        KnowledgeBuilderImpl packageBuilder = new KnowledgeBuilderImpl();
        ProcessBuilderImpl processBuilder = new ProcessBuilderImpl(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        process = new RuleFlowProcess();
        process.setId("org.drools.test.SubProcess");
        process.setName("SubProcess");
        process.setPackageName("org.drools.test");
        start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        actionNode = new ActionNode();
        actionNode.setId(2L);
        actionNode.setName("Action");
        action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setId(3L);
        workItemNode.setName("WorkItem1");
        WorkImpl work = new WorkImpl();
        work.setName("MyWork");
        workItemNode.setWork((Work)work);
        process.addNode((Node)workItemNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)workItemNode, "DROOLS_DEFAULT");
        end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)workItemNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        processBuilder.buildProcess((Process)process, null);
        return packageBuilder.getPackage();
    }

    @Test
    @Ignore
    public void testPersistenceTimer() throws Exception {
        this.setUp();
        Properties properties = new Properties();
        properties.setProperty("drools.commandService", SingleSessionCommandService.class.getName());
        properties.setProperty("drools.processInstanceManagerFactory", InfinispanProcessInstanceManagerFactory.class.getName());
        properties.setProperty("drools.workItemManagerFactory", InfinispanWorkItemManagerFactory.class.getName());
        properties.setProperty("drools.processSignalManagerFactory", InfinispanSignalManagerFactory.class.getName());
        SessionConfiguration config = new SessionConfiguration(properties);
        Field timeManagerField = SessionConfiguration.class.getDeclaredField("timerJobFactoryManager");
        timeManagerField.setAccessible(true);
        timeManagerField.set(config, new InfinispanTimeJobFactoryManager());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        List<KnowledgePackage> kpkgs = this.getProcessTimer();
        kbase.addKnowledgePackages(kpkgs);
        SingleSessionCommandService service = this.createSingleSessionCommandService(kbase, config, this.env);
        long sessionId = service.getSessionId();
        StartProcessCommand startProcessCommand = new StartProcessCommand();
        startProcessCommand.setProcessId("org.drools.test.TestProcess");
        ProcessInstance processInstance = (ProcessInstance)service.execute((Command)startProcessCommand);
        System.out.println("Started process instance " + processInstance.getId());
        Thread.sleep(500L);
        service.dispose();
        service = this.createSingleSessionCommandService(sessionId, kbase, config, this.env);
        GetProcessInstanceCommand getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNotNull((Object)processInstance);
        service.dispose();
        service = this.createSingleSessionCommandService(sessionId, kbase, config, this.env);
        Thread.sleep(5000L);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNull((Object)processInstance);
    }

    private List<KnowledgePackage> getProcessTimer() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.TestProcess");
        process.setName("TestProcess");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        TimerNode timerNode = new TimerNode();
        timerNode.setId(2L);
        timerNode.setName("Timer");
        Timer timer = new Timer();
        timer.setDelay("2000");
        timerNode.setTimer(timer);
        process.addNode((Node)timerNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)timerNode, "DROOLS_DEFAULT");
        ActionNode actionNode = new ActionNode();
        actionNode.setId(3L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)timerNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        KnowledgeBuilderImpl packageBuilder = new KnowledgeBuilderImpl();
        ProcessBuilderImpl processBuilder = new ProcessBuilderImpl(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        ArrayList<KnowledgePackage> list = new ArrayList<KnowledgePackage>();
        list.add((KnowledgePackage)packageBuilder.getPackage());
        return list;
    }

    @Test
    @Ignore
    public void testPersistenceTimer2() throws Exception {
        this.setUp();
        Properties properties = new Properties();
        properties.setProperty("drools.commandService", SingleSessionCommandService.class.getName());
        properties.setProperty("drools.processInstanceManagerFactory", InfinispanProcessInstanceManagerFactory.class.getName());
        properties.setProperty("drools.workItemManagerFactory", InfinispanWorkItemManagerFactory.class.getName());
        properties.setProperty("drools.processSignalManagerFactory", InfinispanSignalManagerFactory.class.getName());
        SessionConfiguration config = new SessionConfiguration(properties);
        config.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        List<KnowledgePackage> kpkgs = this.getProcessTimer2();
        kbase.addKnowledgePackages(kpkgs);
        SingleSessionCommandService service = this.createSingleSessionCommandService(kbase, config, this.env);
        long sessionId = service.getSessionId();
        StartProcessCommand startProcessCommand = new StartProcessCommand();
        startProcessCommand.setProcessId("org.drools.test.TestProcess");
        ProcessInstance processInstance = (ProcessInstance)service.execute((Command)startProcessCommand);
        System.out.println("Started process instance " + processInstance.getId());
        SessionPseudoClock clock = (SessionPseudoClock)service.getKieSession().getSessionClock();
        clock.advanceTime(2000L, TimeUnit.MILLISECONDS);
        service = this.createSingleSessionCommandService(sessionId, kbase, config, this.env);
        GetProcessInstanceCommand getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNull((Object)processInstance);
    }

    private List<KnowledgePackage> getProcessTimer2() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.TestProcess");
        process.setName("TestProcess");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        TimerNode timerNode = new TimerNode();
        timerNode.setId(2L);
        timerNode.setName("Timer");
        Timer timer = new Timer();
        timer.setDelay("0");
        timerNode.setTimer(timer);
        process.addNode((Node)timerNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)timerNode, "DROOLS_DEFAULT");
        ActionNode actionNode = new ActionNode();
        actionNode.setId(3L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("try { Thread.sleep(1000); } catch (Throwable t) {} System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)timerNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        KnowledgeBuilderImpl packageBuilder = new KnowledgeBuilderImpl();
        ProcessBuilderImpl processBuilder = new ProcessBuilderImpl(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        ArrayList<KnowledgePackage> list = new ArrayList<KnowledgePackage>();
        list.add((KnowledgePackage)packageBuilder.getPackage());
        return list;
    }

    private SingleSessionCommandService createSingleSessionCommandService(KnowledgeBase kbase, SessionConfiguration conf, Environment env) {
        SingleSessionCommandService service = new SingleSessionCommandService((KieBase)kbase, (KieSessionConfiguration)conf, env);
        service.addInterceptor((Interceptor)new ManualPersistInterceptor(service));
        service.addInterceptor((Interceptor)new ManualPersistProcessInterceptor(service));
        KnowledgeRuntimeLoggerFactory.newConsoleLogger((KnowledgeRuntimeEventManager)((KnowledgeRuntimeEventManager)service.getKieSession()));
        return service;
    }

    private SingleSessionCommandService createSingleSessionCommandService(long sessionId, KnowledgeBase kbase, SessionConfiguration conf, Environment env) {
        SingleSessionCommandService service = new SingleSessionCommandService(Long.valueOf(sessionId), (KieBase)kbase, (KieSessionConfiguration)conf, env);
        service.addInterceptor((Interceptor)new ManualPersistInterceptor(service));
        service.addInterceptor((Interceptor)new ManualPersistProcessInterceptor(service));
        new KnowledgeLogger(service.getKieSession());
        return service;
    }

    private SingleSessionCommandService createSingleSessionCommandService(KieBase ruleBase, SessionConfiguration conf, Environment env) {
        SingleSessionCommandService service = new SingleSessionCommandService(ruleBase, (KieSessionConfiguration)conf, env);
        service.addInterceptor((Interceptor)new ManualPersistInterceptor(service));
        service.addInterceptor((Interceptor)new ManualPersistProcessInterceptor(service));
        new KnowledgeLogger(service.getKieSession());
        return service;
    }

    private SingleSessionCommandService createSingleSessionCommandService(long sessionId, KieBase ruleBase, SessionConfiguration conf, Environment env) {
        SingleSessionCommandService service = new SingleSessionCommandService(Long.valueOf(sessionId), ruleBase, (KieSessionConfiguration)conf, env);
        service.addInterceptor((Interceptor)new ManualPersistInterceptor(service));
        service.addInterceptor((Interceptor)new ManualPersistProcessInterceptor(service));
        new KnowledgeLogger(service.getKieSession());
        return service;
    }

    private void registerWorkItemHandlers(SingleSessionCommandService service) {
        RegisterWorkItemHandlerCommand registerCommand1 = new RegisterWorkItemHandlerCommand();
        registerCommand1.setWorkItemName("MyWork");
        registerCommand1.setHandler((WorkItemHandler)TestWorkItemHandler.getInstance());
        service.execute((Command)registerCommand1);
    }

    private static class KnowledgeLogger
    extends WorkingMemoryLogger {
        public KnowledgeLogger(KieSession session) {
            super((KnowledgeRuntimeEventManager)session);
        }

        public void logEventCreated(LogEvent logEvent) {
            System.out.println("event: " + logEvent.toString());
        }
    }
}

