/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.correlation;

import java.util.ArrayList;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.infinispan.Cache;
import org.infinispan.manager.DefaultCacheManager;
import org.jbpm.persistence.InfinispanProcessPersistenceContext;
import org.jbpm.persistence.correlation.CorrelationKeyInfo;
import org.jbpm.persistence.correlation.CorrelationPropertyInfo;
import org.jbpm.persistence.processinstance.ProcessEntityHolder;
import org.jbpm.persistence.util.PersistenceUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;

public class CorrelationPersistenceTest {
    private HashMap<String, Object> context;

    @Before
    public void before() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.jbpm.persistence.jpa", false);
        CorrelationKeyFactory factory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
        DefaultCacheManager cm = (DefaultCacheManager)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        if (ut.getStatus() == 6) {
            ut.begin();
        }
        Cache cache = cm.getCache("jbpm-configured-cache");
        cache.put((Object)"correlationInfo1", (Object)new ProcessEntityHolder("correlationInfo1", (CorrelationKeyInfo)factory.newCorrelationKey("test123")));
        ArrayList<String> props = new ArrayList<String>();
        props.add("test123");
        props.add("123test");
        cache.put((Object)"correlationInfo2", (Object)new ProcessEntityHolder("correlationInfo2", (CorrelationKeyInfo)factory.newCorrelationKey(props)));
        if (ut.getStatus() == 0) {
            ut.commit();
        }
    }

    @After
    public void after() {
        try {
            DefaultCacheManager cm = (DefaultCacheManager)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
            UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
            if (ut.getStatus() == 6) {
                ut.begin();
            }
            Cache cache = cm.getCache("jbpm-configured-cache");
            cache.clear();
            if (ut.getStatus() == 0) {
                ut.commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testCreateCorrelation() throws Exception {
        DefaultCacheManager cm = (DefaultCacheManager)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        Cache cache = cm.getCache("jbpm-configured-cache");
        CorrelationKeyInfo correlationKey = new CorrelationKeyInfo();
        correlationKey.addProperty(new CorrelationPropertyInfo("", "test123"));
        Long processInstance = new InfinispanProcessPersistenceContext(cache).getProcessInstanceByCorrelationKey((CorrelationKey)correlationKey);
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((long)correlationKey.getProcessInstanceId(), (long)processInstance);
    }

    @Test
    public void testCreateCorrelationMultiValueDoesNotMatch() throws Exception {
        DefaultCacheManager cm = (DefaultCacheManager)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        Cache cache = cm.getCache("jbpm-configured-cache");
        CorrelationKeyInfo correlationKey = new CorrelationKeyInfo();
        correlationKey.addProperty(new CorrelationPropertyInfo("", "asdf"));
        Long processInstance = new InfinispanProcessPersistenceContext(cache).getProcessInstanceByCorrelationKey((CorrelationKey)correlationKey);
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testCreateCorrelationMultiValueDoesMatch() throws Exception {
        DefaultCacheManager cm = (DefaultCacheManager)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        Cache cache = cm.getCache("jbpm-configured-cache");
        CorrelationKeyFactory factory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
        ArrayList<String> props = new ArrayList<String>();
        props.add("test123");
        props.add("123test");
        CorrelationKeyInfo correlationKey = (CorrelationKeyInfo)factory.newCorrelationKey(props);
        Long processInstance = new InfinispanProcessPersistenceContext(cache).getProcessInstanceByCorrelationKey((CorrelationKey)correlationKey);
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((long)correlationKey.getProcessInstanceId(), (long)processInstance);
    }
}

