/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.session;

import java.util.HashMap;
import org.jbpm.persistence.util.PersistenceUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.infinispan.InfinispanKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class GetProcessInstancesTest {
    private HashMap<String, Object> context;
    private Environment env;
    private KnowledgeBase kbase;
    private long sessionId;

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.jbpm.persistence.jpa");
        this.env = PersistenceUtil.createEnvironment(this.context);
        this.kbase = this.createBase();
        StatefulKnowledgeSession ksession = InfinispanKnowledgeService.newStatefulKnowledgeSession((KieBase)this.kbase, null, (Environment)this.env);
        this.sessionId = ksession.getIdentifier();
        ksession.dispose();
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void getEmptyProcessInstances() throws Exception {
        StatefulKnowledgeSession ksession = this.reloadKnowledgeSession();
        Assert.assertEquals((long)0L, (long)ksession.getProcessInstances().size());
        ksession.dispose();
    }

    @Test
    public void create2ProcessInstances() throws Exception {
        long[] processId = new long[2];
        StatefulKnowledgeSession ksession = this.reloadKnowledgeSession();
        processId[0] = ksession.createProcessInstance("org.jbpm.processinstance.helloworld", null).getId();
        processId[1] = ksession.createProcessInstance("org.jbpm.processinstance.helloworld", null).getId();
        ksession.dispose();
        this.assertProcessInstancesExist(processId);
    }

    private void assertProcessInstancesExist(long[] processId) {
        StatefulKnowledgeSession ksession = this.reloadKnowledgeSession();
        for (long id : processId) {
            Assert.assertNotNull((String)("Process instance " + id + " should not exist!"), (Object)ksession.getProcessInstance(id));
        }
    }

    private void assertProcessInstancesNotExist(long[] processId) {
        StatefulKnowledgeSession ksession = this.reloadKnowledgeSession();
        for (long id : processId) {
            Assert.assertNull((Object)ksession.getProcessInstance(id));
        }
    }

    private KnowledgeBase createBase() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"processinstance/HelloWorld.rf"), ResourceType.DRF);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        return kbuilder.newKnowledgeBase();
    }

    private StatefulKnowledgeSession reloadKnowledgeSession() {
        return InfinispanKnowledgeService.loadStatefulKnowledgeSession((long)this.sessionId, (KieBase)this.kbase, null, (Environment)this.env);
    }

    private StatefulKnowledgeSession reloadKnowledgeSession(StatefulKnowledgeSession ksession) {
        ksession.dispose();
        return this.reloadKnowledgeSession();
    }
}

