/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.session;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.drools.core.WorkItemHandlerNotFoundException;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.process.core.Work;
import org.drools.core.process.core.datatype.DataType;
import org.drools.core.process.core.datatype.impl.type.IntegerDataType;
import org.drools.core.process.core.datatype.impl.type.ObjectDataType;
import org.drools.core.process.core.datatype.impl.type.StringDataType;
import org.drools.core.process.core.impl.ParameterDefinitionImpl;
import org.drools.core.process.core.impl.WorkImpl;
import org.drools.core.runtime.process.ProcessRuntimeFactory;
import org.drools.core.runtime.process.ProcessRuntimeFactoryService;
import org.infinispan.Cache;
import org.infinispan.manager.DefaultCacheManager;
import org.jbpm.persistence.processinstance.ProcessEntityHolder;
import org.jbpm.persistence.processinstance.ProcessInstanceInfo;
import org.jbpm.persistence.session.objects.Person;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.instance.ProcessRuntimeFactoryServiceImpl;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.StartNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.infinispan.InfinispanKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemPersistenceTest {
    private static Logger logger = LoggerFactory.getLogger(WorkItemPersistenceTest.class);
    private HashMap<String, Object> context;
    private DefaultCacheManager cm;

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.jbpm.persistence.jpa", false);
        this.cm = (DefaultCacheManager)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.cleanUp(this.context);
    }

    protected StatefulKnowledgeSession createSession(KnowledgeBase kbase) {
        return InfinispanKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)PersistenceUtil.createEnvironment(this.context));
    }

    @Test
    @Ignore
    public void testCancelNonRegisteredWorkItemHandler() {
        String processId = "org.drools.actions";
        String workName = "Unnexistent Task";
        RuleFlowProcess process = this.getWorkItemProcess(processId, workName);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        ((KnowledgeBaseImpl)kbase).addProcess((Process)process);
        StatefulKnowledgeSession ksession = this.createSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler(workName, (WorkItemHandler)new DoNothingWorkItemHandler());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("UserName", "John Doe");
        parameters.put("Person", new Person("John Doe"));
        ProcessInstance processInstance = ksession.startProcess("org.drools.actions", parameters);
        long processInstanceId = processInstance.getId();
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        ksession.getWorkItemManager().registerWorkItemHandler(workName, null);
        try {
            ksession.abortProcessInstance(processInstanceId);
            Assert.fail((String)("should fail if WorkItemHandler for" + workName + "is not registered"));
        }
        catch (WorkItemHandlerNotFoundException workItemHandlerNotFoundException) {
            // empty catch block
        }
        Assert.assertEquals((long)3L, (long)processInstance.getState());
    }

    private RuleFlowProcess getWorkItemProcess(String processId, String workName) {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId(processId);
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Variable variable = new Variable();
        variable.setName("UserName");
        variable.setType((DataType)new StringDataType());
        variables.add(variable);
        variable = new Variable();
        variable.setName("MyObject");
        variable.setType((DataType)new ObjectDataType());
        variables.add(variable);
        variable = new Variable();
        variable.setName("Number");
        variable.setType((DataType)new IntegerDataType());
        variables.add(variable);
        process.getVariableScope().setVariables(variables);
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        HumanTaskNode workItemNode = new HumanTaskNode();
        workItemNode.setName("workItemNode");
        workItemNode.setId(2L);
        workItemNode.addInMapping("Attachment", "MyObject");
        workItemNode.addOutMapping("Result", "MyObject");
        workItemNode.addOutMapping("Result.length()", "Number");
        WorkImpl work = new WorkImpl();
        work.setName(workName);
        HashSet<ParameterDefinitionImpl> parameterDefinitions = new HashSet<ParameterDefinitionImpl>();
        ParameterDefinitionImpl parameterDefinition = new ParameterDefinitionImpl("ActorId", (DataType)new StringDataType());
        parameterDefinitions.add(parameterDefinition);
        parameterDefinition = new ParameterDefinitionImpl("Content", (DataType)new StringDataType());
        parameterDefinitions.add(parameterDefinition);
        parameterDefinition = new ParameterDefinitionImpl("Comment", (DataType)new StringDataType());
        parameterDefinitions.add(parameterDefinition);
        work.setParameterDefinitions(parameterDefinitions);
        work.setParameter("ActorId", (Object)"#{UserName}");
        work.setParameter("Content", (Object)"#{Person.name}");
        workItemNode.setWork((Work)work);
        EndNode endNode = new EndNode();
        endNode.setName("End");
        endNode.setId(3L);
        this.connect((org.jbpm.workflow.core.Node)startNode, (org.jbpm.workflow.core.Node)workItemNode);
        this.connect((org.jbpm.workflow.core.Node)workItemNode, (org.jbpm.workflow.core.Node)endNode);
        process.addNode((Node)startNode);
        process.addNode((Node)workItemNode);
        process.addNode((Node)endNode);
        return process;
    }

    private void connect(org.jbpm.workflow.core.Node sourceNode, org.jbpm.workflow.core.Node targetNode) {
        new ConnectionImpl((Node)sourceNode, "DROOLS_DEFAULT", (Node)targetNode, "DROOLS_DEFAULT");
    }

    @Test
    public void testHumanTask() {
        ArrayList<ProcessInstanceInfo> procInstInfoList = WorkItemPersistenceTest.retrieveProcessInstanceInfo(this.cm);
        int numProcInstInfos = procInstInfoList.size();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.humantask\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <humanTask id=\"2\" name=\"HumanTask\" >\n      <work name=\"Human Task\" >\n        <parameter name=\"ActorId\" >\n          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n          <value>John Doe</value>\n        </parameter>\n        <parameter name=\"TaskName\" >\n          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n          <value>Do something</value>\n        </parameter>\n        <parameter name=\"Priority\" >\n          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Comment\" >\n          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n      </work>\n    </humanTask>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createSession(kbase);
        DoNothingWorkItemHandler handler = new DoNothingWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = ksession.startProcess("org.drools.humantask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        int state = processInstance.getState();
        switch (state) {
            case 3: {
                logger.debug("STATE_ABORTED");
                break;
            }
            case 1: {
                logger.debug("STATE_ACTIVE");
                break;
            }
            case 2: {
                logger.debug("STATE_COMPLETED");
                break;
            }
            case 0: {
                logger.debug("STATE_PENDING");
                break;
            }
            case 4: {
                logger.debug("STATE_SUSPENDED");
                break;
            }
            default: {
                logger.debug("Unknown state: " + state);
            }
        }
        procInstInfoList = WorkItemPersistenceTest.retrieveProcessInstanceInfo(this.cm);
        Assert.assertTrue((procInstInfoList.size() - numProcInstInfos == 1 ? 1 : 0) != 0);
        ProcessInstanceInfo processInstanceInfoMadeInThisTest = (ProcessInstanceInfo)procInstInfoList.get(numProcInstInfos);
        Assert.assertNotNull((String)"ByteArray of ProcessInstanceInfo from this test is not filled and null!", (Object)processInstanceInfoMadeInThisTest.getProcessInstanceByteArray());
        Assert.assertTrue((String)"ByteArray of ProcessInstanceInfo from this test is not filled and empty!", (processInstanceInfoMadeInThisTest.getProcessInstanceByteArray().length > 0 ? 1 : 0) != 0);
    }

    public static ArrayList<ProcessInstanceInfo> retrieveProcessInstanceInfo(DefaultCacheManager cm) {
        Cache cache = cm.getCache("jbpm-configured-cache");
        Set keyset = cache.keySet();
        ArrayList<ProcessInstanceInfo> retval = new ArrayList<ProcessInstanceInfo>();
        for (String key : keyset) {
            if (!key.startsWith("processInstanceInfo")) continue;
            ProcessEntityHolder holder = (ProcessEntityHolder)cache.get((Object)key);
            ProcessInstanceInfo procInstInfo = holder.getProcessInstanceInfo();
            retval.add(procInstInfo);
            logger.trace("> " + procInstInfo);
        }
        return retval;
    }

    static {
        ProcessRuntimeFactory.setProcessRuntimeFactoryService((ProcessRuntimeFactoryService)new ProcessRuntimeFactoryServiceImpl());
    }
}

