/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.processinstance;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import org.drools.persistence.info.EntityHolder;
import org.drools.persistence.info.SessionInfo;
import org.drools.persistence.info.WorkItemInfo;
import org.hibernate.search.annotations.Indexed;
import org.infinispan.util.Base64;
import org.jbpm.persistence.correlation.CorrelationKeyInfo;
import org.jbpm.persistence.correlation.CorrelationPropertyInfo;
import org.jbpm.persistence.processinstance.ProcessInstanceInfo;
import org.kie.internal.process.CorrelationProperty;

@Entity
@Indexed
public class ProcessEntityHolder
extends EntityHolder {
    @org.hibernate.search.annotations.Field
    private String processInstanceEventTypes;
    @org.hibernate.search.annotations.Field
    private Long processInstanceId;
    @org.hibernate.search.annotations.Field
    private Date processInstanceLastModificationDate;
    @org.hibernate.search.annotations.Field
    private Date processInstanceLastReadDate;
    @org.hibernate.search.annotations.Field
    private String processId;
    @org.hibernate.search.annotations.Field
    private String processInstanceByteArray;
    @org.hibernate.search.annotations.Field
    private Date processInstanceStartDate;
    @org.hibernate.search.annotations.Field
    private Integer processInstanceState;
    @org.hibernate.search.annotations.Field
    private Integer processInstanceVersion;
    @org.hibernate.search.annotations.Field
    private long correlationKeyId;
    @org.hibernate.search.annotations.Field
    private String correlationKeyName;
    @org.hibernate.search.annotations.Field
    private String correlationKeyProperties;

    public ProcessEntityHolder(String key, SessionInfo sessionInfo) {
        super(key, sessionInfo);
    }

    public ProcessEntityHolder(String key, WorkItemInfo workItemInfo) {
        super(key, workItemInfo);
    }

    public ProcessEntityHolder(String key, ProcessInstanceInfo processInstanceInfo) {
        super(key, "processInstanceInfo");
        this.processInstanceEventTypes = ProcessEntityHolder.generateString(processInstanceInfo.getEventTypes());
        this.processInstanceId = processInstanceInfo.getId();
        this.processInstanceLastModificationDate = processInstanceInfo.getLastModificationDate();
        this.processInstanceLastReadDate = processInstanceInfo.getLastReadDate();
        this.processId = processInstanceInfo.getProcessId();
        processInstanceInfo.transform();
        this.processInstanceByteArray = Base64.encodeBytes((byte[])processInstanceInfo.getProcessInstanceByteArray());
        this.processInstanceStartDate = processInstanceInfo.getStartDate();
        this.processInstanceState = processInstanceInfo.getState();
        this.processInstanceVersion = processInstanceInfo.getVersion();
    }

    public ProcessEntityHolder(String key, CorrelationKeyInfo correlationKeyInfo) {
        super(key, "correlationInfo");
        this.correlationKeyId = correlationKeyInfo.getId() == 0L ? (long)correlationKeyInfo.getProperties().size() : correlationKeyInfo.getId();
        this.correlationKeyName = correlationKeyInfo.getName();
        this.processInstanceId = correlationKeyInfo.getProcessInstanceId();
        this.correlationKeyProperties = ProcessEntityHolder.generateString(correlationKeyInfo.getProperties());
    }

    private void set(Object obj, String fieldName, Object value) {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Cant set field " + fieldName, e);
        }
    }

    public ProcessInstanceInfo getProcessInstanceInfo() {
        ProcessInstanceInfo info = new ProcessInstanceInfo();
        info.setId(this.processInstanceId);
        this.set(info, "lastModificationDate", this.processInstanceLastModificationDate);
        this.set(info, "lastReadDate", this.processInstanceLastReadDate);
        this.set(info, "processId", this.processId);
        this.set(info, "processInstanceByteArray", Base64.decode((String)this.processInstanceByteArray));
        this.set(info, "startDate", this.processInstanceStartDate);
        this.set(info, "state", this.processInstanceState);
        this.set(info, "version", this.processInstanceVersion);
        this.set(info, "eventTypes", ProcessEntityHolder.toSet(this.processInstanceEventTypes));
        return info;
    }

    public CorrelationKeyInfo getCorrelationKeyInfo() {
        CorrelationKeyInfo info = new CorrelationKeyInfo();
        info.setName(this.correlationKeyName);
        info.setProcessInstanceId(this.processInstanceId.longValue());
        List<CorrelationPropertyInfo> props = ProcessEntityHolder.toProperties(this.correlationKeyProperties);
        for (CorrelationPropertyInfo prop : props) {
            info.addProperty(prop);
        }
        this.set(info, "id", this.correlationKeyId);
        return info;
    }

    public static String generateString(List<CorrelationProperty<?>> properties) {
        StringBuilder sb = new StringBuilder();
        if (properties != null) {
            Iterator<CorrelationProperty<?>> iter = properties.iterator();
            while (iter.hasNext()) {
                CorrelationProperty<?> cp = iter.next();
                sb.append(cp.getName()).append("=").append(cp.getValue());
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public static String generateString(Set<String> setOfStrings) {
        StringBuilder sb = new StringBuilder();
        if (setOfStrings != null) {
            Iterator<String> iter = setOfStrings.iterator();
            while (iter.hasNext()) {
                sb.append(iter.next());
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public static Set<String> toSet(String setOfStringsString) {
        if (setOfStringsString != null) {
            String[] splitted = setOfStringsString.split(",");
            return new HashSet<String>(Arrays.asList(splitted));
        }
        return new HashSet<String>();
    }

    public static List<CorrelationPropertyInfo> toProperties(String properties) {
        String[] props = properties.split(",");
        ArrayList<CorrelationPropertyInfo> retval = new ArrayList<CorrelationPropertyInfo>(props.length);
        for (String prop : props) {
            String[] sub = prop.split("=");
            String key = sub[0];
            String value = sub[1];
            retval.add(new CorrelationPropertyInfo(key, value));
        }
        return retval;
    }

    public String getProcessInstanceEventTypes() {
        return this.processInstanceEventTypes;
    }

    public void setProcessInstanceEventTypes(String processInstanceEventTypes) {
        this.processInstanceEventTypes = processInstanceEventTypes;
    }

    public Date getProcessInstanceLastModificationDate() {
        return this.processInstanceLastModificationDate;
    }

    public void setProcessInstanceLastModificationDate(Date processInstanceLastModificationDate) {
        this.processInstanceLastModificationDate = processInstanceLastModificationDate;
    }

    public Date getProcessInstanceLastReadDate() {
        return this.processInstanceLastReadDate;
    }

    public void setProcessInstanceLastReadDate(Date processInstanceLastReadDate) {
        this.processInstanceLastReadDate = processInstanceLastReadDate;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getProcessInstanceByteArray() {
        return this.processInstanceByteArray;
    }

    public void setProcessInstanceByteArray(String processInstanceByteArray) {
        this.processInstanceByteArray = processInstanceByteArray;
    }

    public Date getProcessInstanceStartDate() {
        return this.processInstanceStartDate;
    }

    public void setProcessInstanceStartDate(Date processInstanceStartDate) {
        this.processInstanceStartDate = processInstanceStartDate;
    }

    public Integer getProcessInstanceState() {
        return this.processInstanceState;
    }

    public void setProcessInstanceState(Integer processInstanceState) {
        this.processInstanceState = processInstanceState;
    }

    public Integer getProcessInstanceVersion() {
        return this.processInstanceVersion;
    }

    public void setProcessInstanceVersion(Integer processInstanceVersion) {
        this.processInstanceVersion = processInstanceVersion;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public long getCorrelationKeyId() {
        return this.correlationKeyId;
    }

    public void setCorrelationKeyId(long correlationKeyId) {
        this.correlationKeyId = correlationKeyId;
    }

    public String getCorrelationKeyName() {
        return this.correlationKeyName;
    }

    public void setCorrelationKeyName(String correlationKeyName) {
        this.correlationKeyName = correlationKeyName;
    }

    public String getCorrelationKeyProperties() {
        return this.correlationKeyProperties;
    }

    public void setCorrelationKeyProperties(String correlationKeyProperties) {
        this.correlationKeyProperties = correlationKeyProperties;
    }
}

