/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence;

import java.lang.reflect.Field;
import java.util.Collection;
import org.drools.core.command.CommandService;
import org.drools.core.command.impl.AbstractInterceptor;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.runtime.process.AbortProcessInstanceCommand;
import org.drools.core.command.runtime.process.AbortWorkItemCommand;
import org.drools.core.command.runtime.process.CompleteWorkItemCommand;
import org.drools.core.command.runtime.process.CreateCorrelatedProcessInstanceCommand;
import org.drools.core.command.runtime.process.CreateProcessInstanceCommand;
import org.drools.core.command.runtime.process.SignalEventCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.command.runtime.process.StartProcessInstanceCommand;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.persistence.SingleSessionCommandService;
import org.jbpm.persistence.ProcessPersistenceContext;
import org.jbpm.persistence.ProcessPersistenceContextManager;
import org.jbpm.persistence.processinstance.ProcessInstanceInfo;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.command.Context;

public class ManualPersistProcessInterceptor
extends AbstractInterceptor {
    private final SingleSessionCommandService interceptedService;

    public ManualPersistProcessInterceptor(SingleSessionCommandService interceptedService) {
        this.interceptedService = interceptedService;
    }

    public <T> T execute(Command<T> command) {
        RuntimeException error = null;
        Object result = null;
        try {
            result = this.executeNext(command);
        }
        catch (RuntimeException e) {
            error = e;
        }
        KieSession ksession = this.interceptedService.getKieSession();
        try {
            Field jpmField = SingleSessionCommandService.class.getDeclaredField("jpm");
            jpmField.setAccessible(true);
            Object jpm = jpmField.get(this.interceptedService);
            if (error == null && this.isValidCommand(command)) {
                this.executeNext((Command)new PersistProcessCommand(jpm, ksession));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't force persistence of process instance infos", e);
        }
        if (error != null) {
            throw error;
        }
        return (T)result;
    }

    protected boolean isValidCommand(Command<?> command) {
        return command instanceof StartProcessCommand || command instanceof CreateProcessInstanceCommand || command instanceof CreateCorrelatedProcessInstanceCommand || command instanceof StartProcessInstanceCommand || command instanceof SignalEventCommand || command instanceof CompleteWorkItemCommand || command instanceof AbortWorkItemCommand || command instanceof AbortProcessInstanceCommand || command instanceof FireAllRulesCommand;
    }

    public CommandService getInterceptedService() {
        return this.interceptedService;
    }

    public static class PersistProcessCommand
    implements GenericCommand<Void> {
        private final ProcessPersistenceContext persistenceContext;
        private final KieSession ksession;

        public PersistProcessCommand(Object jpm, KieSession ksession) {
            this.persistenceContext = ((ProcessPersistenceContextManager)jpm).getProcessPersistenceContext();
            this.ksession = ksession;
        }

        public Void execute(Context context) {
            Collection processInstances = this.ksession.getProcessInstances();
            for (Object obj : processInstances) {
                org.jbpm.process.instance.ProcessInstance instance = (org.jbpm.process.instance.ProcessInstance)obj;
                boolean notCompeted = instance.getState() != 2;
                boolean notAborted = instance.getState() != 3;
                boolean hasId = instance.getId() > 0L;
                if (!hasId || !notCompeted || !notAborted) continue;
                ProcessInstanceInfo info = new ProcessInstanceInfo((ProcessInstance)instance, this.ksession.getEnvironment());
                info.setId(Long.valueOf(instance.getId()));
                info.transform();
                this.persistenceContext.persist(info);
            }
            return null;
        }
    }
}

